/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.data.repository.query;

import org.springframework.data.repository.query.spi.EvaluationContextExtensionSupport;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityEvaluationContextExtension
extends EvaluationContextExtensionSupport {
    private Authentication authentication;

    public SecurityEvaluationContextExtension() {
    }

    public SecurityEvaluationContextExtension(Authentication authentication) {
        this.authentication = authentication;
    }

    public String getExtensionId() {
        return "security";
    }

    public Object getRootObject() {
        Authentication authentication = this.getAuthentication();
        return new SecurityExpressionRoot(authentication){};
    }

    private Authentication getAuthentication() {
        if (this.authentication != null) {
            return this.authentication;
        }
        SecurityContext context = SecurityContextHolder.getContext();
        return context.getAuthentication();
    }
}

