/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherConfigurer;
import org.springframework.security.web.util.RequestMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestMatcherMappingConfigurer<B extends SecurityBuilder<O>, C, O>
extends AbstractRequestMatcherConfigurer<B, C, O> {
    private List<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
    private List<RequestMatcher> unmappedMatchers;

    final List<UrlMapping> getUrlMappings() {
        return this.urlMappings;
    }

    final void addMapping(UrlMapping urlMapping) {
        this.unmappedMatchers = null;
        this.urlMappings.add(urlMapping);
    }

    @Override
    protected final C chainRequestMatchers(List<RequestMatcher> requestMatchers) {
        this.unmappedMatchers = requestMatchers;
        return this.chainRequestMatchersInternal(requestMatchers);
    }

    protected abstract C chainRequestMatchersInternal(List<RequestMatcher> var1);

    final void addMapping(int index, UrlMapping urlMapping) {
        this.urlMappings.add(index, urlMapping);
    }

    final LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> createRequestMap() {
        if (this.unmappedMatchers != null) {
            throw new IllegalStateException("An incomplete mapping was found for " + this.unmappedMatchers + ". Try completing it with something like requestUrls().<something>.hasRole('USER')");
        }
        LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
        for (UrlMapping mapping : this.getUrlMappings()) {
            RequestMatcher matcher = mapping.getRequestMatcher();
            Collection<ConfigAttribute> configAttrs = mapping.getConfigAttrs();
            requestMap.put(matcher, configAttrs);
        }
        return requestMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UrlMapping {
        private RequestMatcher requestMatcher;
        private Collection<ConfigAttribute> configAttrs;

        UrlMapping(RequestMatcher requestMatcher, Collection<ConfigAttribute> configAttrs) {
            this.requestMatcher = requestMatcher;
            this.configAttrs = configAttrs;
        }

        public RequestMatcher getRequestMatcher() {
            return this.requestMatcher;
        }

        public Collection<ConfigAttribute> getConfigAttrs() {
            return this.configAttrs;
        }
    }
}

