/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt;

import java.nio.CharBuffer;
import java.util.Collections;
import java.util.Map;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHeader;
import org.springframework.security.jwt.JwtHeaderHelper;
import org.springframework.security.jwt.JwtImpl;
import org.springframework.security.jwt.codec.Codecs;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.jwt.crypto.sign.Signer;

public class JwtHelper {
    static byte[] PERIOD = Codecs.utf8Encode(".");

    public static Jwt decode(String token) {
        byte[] crypto;
        boolean emptyCrypto;
        int firstPeriod = token.indexOf(46);
        int lastPeriod = token.lastIndexOf(46);
        if (firstPeriod <= 0 || lastPeriod <= firstPeriod) {
            throw new IllegalArgumentException("JWT must have 3 tokens");
        }
        CharBuffer buffer = CharBuffer.wrap(token, 0, firstPeriod);
        JwtHeader header = JwtHeaderHelper.create(buffer.toString());
        buffer.limit(lastPeriod).position(firstPeriod + 1);
        byte[] claims = Codecs.b64UrlDecode(buffer);
        boolean bl = emptyCrypto = lastPeriod == token.length() - 1;
        if (emptyCrypto) {
            if (!"none".equals(header.parameters.alg)) {
                throw new IllegalArgumentException("Signed or encrypted token must have non-empty crypto segment");
            }
            crypto = new byte[]{};
        } else {
            buffer.limit(token.length()).position(lastPeriod + 1);
            crypto = Codecs.b64UrlDecode(buffer);
        }
        return new JwtImpl(header, claims, crypto);
    }

    public static Jwt decodeAndVerify(String token, SignatureVerifier verifier) {
        Jwt jwt = JwtHelper.decode(token);
        jwt.verifySignature(verifier);
        return jwt;
    }

    public static Jwt encode(CharSequence content, Signer signer) {
        return JwtHelper.encode(content, signer, Collections.<String, String>emptyMap());
    }

    public static Jwt encode(CharSequence content, Signer signer, Map<String, String> headers) {
        JwtHeader header = JwtHeaderHelper.create(signer, headers);
        byte[] claims = Codecs.utf8Encode(content);
        byte[] crypto = signer.sign(Codecs.concat(Codecs.b64UrlEncode(header.bytes()), PERIOD, Codecs.b64UrlEncode(claims)));
        return new JwtImpl(header, claims, crypto);
    }
}

