/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.web.csrf;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpMessageTypeMatcher;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.InvalidCsrfTokenException;
import org.springframework.security.web.csrf.MissingCsrfTokenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsrfChannelInterceptor
extends ChannelInterceptorAdapter {
    private final MessageMatcher<Object> matcher = new SimpMessageTypeMatcher(SimpMessageType.CONNECT);

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        CsrfToken expectedToken;
        if (!this.matcher.matches(message)) {
            return message;
        }
        Map sessionAttributes = SimpMessageHeaderAccessor.getSessionAttributes((Map)message.getHeaders());
        CsrfToken csrfToken = expectedToken = sessionAttributes == null ? null : (CsrfToken)sessionAttributes.get(CsrfToken.class.getName());
        if (expectedToken == null) {
            throw new MissingCsrfTokenException(null);
        }
        String actualTokenValue = SimpMessageHeaderAccessor.wrap(message).getFirstNativeHeader(expectedToken.getHeaderName());
        boolean csrfCheckPassed = expectedToken.getToken().equals(actualTokenValue);
        if (csrfCheckPassed) {
            return message;
        }
        throw new InvalidCsrfTokenException(expectedToken, actualTokenValue);
    }
}

