/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.context;

import java.lang.annotation.Annotation;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class AuthenticationPrincipalArgumentResolver
implements HandlerMethodArgumentResolver {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private ExpressionParser parser = new SpelExpressionParser();
    private final Class<AuthenticationPrincipal> annotationType = AuthenticationPrincipal.class;
    private SecurityAnnotationScanner<AuthenticationPrincipal> scanner = SecurityAnnotationScanners.requireUnique(this.annotationType);
    private boolean useAnnotationTemplate = false;

    public boolean supportsParameter(MethodParameter parameter) {
        return this.findMethodAnnotation(parameter) != null;
    }

    public @Nullable Object resolveArgument(MethodParameter parameter, Message<?> message) {
        Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        AuthenticationPrincipal authPrincipal = this.findMethodAnnotation(parameter);
        Assert.notNull((Object)authPrincipal, (String)"AuthenticationPrincipal must not be null. Run supports first");
        String expressionToParse = authPrincipal.expression();
        if (StringUtils.hasLength((String)expressionToParse)) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject(principal);
            context.setVariable("this", principal);
            Expression expression = this.parser.parseExpression(expressionToParse);
            principal = expression.getValue((EvaluationContext)context);
        }
        if (principal != null && !ClassUtils.isAssignable((Class)parameter.getParameterType(), principal.getClass())) {
            if (authPrincipal.errorOnInvalidType()) {
                throw new ClassCastException(String.valueOf(principal) + " is not assignable to " + String.valueOf(parameter.getParameterType()));
            }
            return null;
        }
        return principal;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public void setTemplateDefaults(AnnotationTemplateExpressionDefaults templateDefaults) {
        this.useAnnotationTemplate = templateDefaults != null;
        this.scanner = SecurityAnnotationScanners.requireUnique(AuthenticationPrincipal.class, (AnnotationTemplateExpressionDefaults)templateDefaults);
    }

    private @Nullable AuthenticationPrincipal findMethodAnnotation(MethodParameter parameter) {
        Annotation[] annotationsToSearch;
        if (this.useAnnotationTemplate) {
            return (AuthenticationPrincipal)this.scanner.scan(parameter.getParameter());
        }
        AuthenticationPrincipal annotation = (AuthenticationPrincipal)parameter.getParameterAnnotation(this.annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Annotation toSearch : annotationsToSearch = parameter.getParameterAnnotations()) {
            annotation = (AuthenticationPrincipal)AnnotationUtils.findAnnotation(toSearch.annotationType(), this.annotationType);
            if (annotation == null) continue;
            return (AuthenticationPrincipal)MergedAnnotations.from((Annotation[])new Annotation[]{toSearch}).get(this.annotationType).synthesize();
        }
        return null;
    }
}

