/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwsEncoder;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.util.StringUtils;

final class OAuth2ConfigurerUtils {
    private OAuth2ConfigurerUtils() {
    }

    static <B extends HttpSecurityBuilder<B>> RegisteredClientRepository getRegisteredClientRepository(B builder) {
        RegisteredClientRepository registeredClientRepository = (RegisteredClientRepository)builder.getSharedObject(RegisteredClientRepository.class);
        if (registeredClientRepository == null) {
            registeredClientRepository = OAuth2ConfigurerUtils.getBean(builder, RegisteredClientRepository.class);
            builder.setSharedObject(RegisteredClientRepository.class, (Object)registeredClientRepository);
        }
        return registeredClientRepository;
    }

    static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizationService getAuthorizationService(B builder) {
        OAuth2AuthorizationService authorizationService = (OAuth2AuthorizationService)builder.getSharedObject(OAuth2AuthorizationService.class);
        if (authorizationService == null) {
            authorizationService = OAuth2ConfigurerUtils.getOptionalBean(builder, OAuth2AuthorizationService.class);
            if (authorizationService == null) {
                authorizationService = new InMemoryOAuth2AuthorizationService();
            }
            builder.setSharedObject(OAuth2AuthorizationService.class, (Object)authorizationService);
        }
        return authorizationService;
    }

    static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizationConsentService getAuthorizationConsentService(B builder) {
        OAuth2AuthorizationConsentService authorizationConsentService = (OAuth2AuthorizationConsentService)builder.getSharedObject(OAuth2AuthorizationConsentService.class);
        if (authorizationConsentService == null) {
            authorizationConsentService = OAuth2ConfigurerUtils.getOptionalBean(builder, OAuth2AuthorizationConsentService.class);
            if (authorizationConsentService == null) {
                authorizationConsentService = new InMemoryOAuth2AuthorizationConsentService();
            }
            builder.setSharedObject(OAuth2AuthorizationConsentService.class, (Object)authorizationConsentService);
        }
        return authorizationConsentService;
    }

    static <B extends HttpSecurityBuilder<B>> JwtEncoder getJwtEncoder(B builder) {
        JwtEncoder jwtEncoder = (JwtEncoder)builder.getSharedObject(JwtEncoder.class);
        if (jwtEncoder == null) {
            jwtEncoder = OAuth2ConfigurerUtils.getOptionalBean(builder, JwtEncoder.class);
            if (jwtEncoder == null) {
                JWKSource<SecurityContext> jwkSource = OAuth2ConfigurerUtils.getJwkSource(builder);
                jwtEncoder = new NimbusJwsEncoder(jwkSource);
            }
            builder.setSharedObject(JwtEncoder.class, (Object)jwtEncoder);
        }
        return jwtEncoder;
    }

    static <B extends HttpSecurityBuilder<B>> JWKSource<SecurityContext> getJwkSource(B builder) {
        JWKSource jwkSource = (JWKSource)builder.getSharedObject(JWKSource.class);
        if (jwkSource == null) {
            ResolvableType type = ResolvableType.forClassWithGenerics(JWKSource.class, (Class[])new Class[]{SecurityContext.class});
            jwkSource = (JWKSource)OAuth2ConfigurerUtils.getBean(builder, type);
            builder.setSharedObject(JWKSource.class, (Object)jwkSource);
        }
        return jwkSource;
    }

    static <B extends HttpSecurityBuilder<B>> OAuth2TokenCustomizer<JwtEncodingContext> getJwtCustomizer(B builder) {
        ResolvableType type;
        OAuth2TokenCustomizer jwtCustomizer = (OAuth2TokenCustomizer)builder.getSharedObject(OAuth2TokenCustomizer.class);
        if (jwtCustomizer == null && (jwtCustomizer = (OAuth2TokenCustomizer)OAuth2ConfigurerUtils.getOptionalBean(builder, type = ResolvableType.forClassWithGenerics(OAuth2TokenCustomizer.class, (Class[])new Class[]{JwtEncodingContext.class}))) != null) {
            builder.setSharedObject(OAuth2TokenCustomizer.class, (Object)jwtCustomizer);
        }
        return jwtCustomizer;
    }

    static <B extends HttpSecurityBuilder<B>> ProviderSettings getProviderSettings(B builder) {
        ProviderSettings providerSettings = (ProviderSettings)builder.getSharedObject(ProviderSettings.class);
        if (providerSettings == null) {
            providerSettings = OAuth2ConfigurerUtils.getOptionalBean(builder, ProviderSettings.class);
            if (providerSettings == null) {
                providerSettings = ProviderSettings.builder().build();
            }
            builder.setSharedObject(ProviderSettings.class, (Object)providerSettings);
        }
        return providerSettings;
    }

    static <B extends HttpSecurityBuilder<B>, T> T getBean(B builder, Class<T> type) {
        return (T)((ApplicationContext)builder.getSharedObject(ApplicationContext.class)).getBean(type);
    }

    static <B extends HttpSecurityBuilder<B>, T> T getBean(B builder, ResolvableType type) {
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(type);
        if (names.length == 1) {
            return (T)context.getBean(names[0]);
        }
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        throw new NoSuchBeanDefinitionException(type);
    }

    static <B extends HttpSecurityBuilder<B>, T> T getOptionalBean(B builder, Class<T> type) {
        Map beansMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)builder.getSharedObject(ApplicationContext.class)), type);
        if (beansMap.size() > 1) {
            throw new NoUniqueBeanDefinitionException(type, beansMap.size(), "Expected single matching bean of type '" + type.getName() + "' but found " + beansMap.size() + ": " + StringUtils.collectionToCommaDelimitedString(beansMap.keySet()));
        }
        return !beansMap.isEmpty() ? (T)beansMap.values().iterator().next() : null;
    }

    static <B extends HttpSecurityBuilder<B>, T> T getOptionalBean(B builder, ResolvableType type) {
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(type);
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        return (T)(names.length == 1 ? context.getBean(names[0]) : null);
    }
}

