/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.authentication;

import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.context.Context;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2AuthenticationContext
implements Context {
    private final Map<Object, Object> context;

    public OAuth2AuthenticationContext(Authentication authentication, @Nullable Map<Object, Object> context) {
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        this.context = new HashMap<Object, Object>();
        if (!CollectionUtils.isEmpty(context)) {
            this.context.putAll(context);
        }
        this.context.put(Authentication.class, authentication);
    }

    public <T extends Authentication> T getAuthentication() {
        return (T)this.get(Authentication.class);
    }

    @Override
    public <V> V get(Object key) {
        return (V)this.context.get(key);
    }

    @Override
    public boolean hasKey(Object key) {
        return this.context.containsKey(key);
    }
}

