/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.util.Assert;

public final class InMemoryOAuth2AuthorizationService
implements OAuth2AuthorizationService {
    private final Map<String, OAuth2Authorization> authorizations = new ConcurrentHashMap<String, OAuth2Authorization>();

    public InMemoryOAuth2AuthorizationService() {
        this(Collections.emptyList());
    }

    public InMemoryOAuth2AuthorizationService(OAuth2Authorization ... authorizations) {
        this(Arrays.asList(authorizations));
    }

    public InMemoryOAuth2AuthorizationService(List<OAuth2Authorization> authorizations) {
        Assert.notNull(authorizations, (String)"authorizations cannot be null");
        authorizations.forEach(authorization -> {
            Assert.notNull((Object)authorization, (String)"authorization cannot be null");
            Assert.isTrue((!this.authorizations.containsKey(authorization.getId()) ? 1 : 0) != 0, (String)("The authorization must be unique. Found duplicate identifier: " + authorization.getId()));
            this.authorizations.put(authorization.getId(), (OAuth2Authorization)authorization);
        });
    }

    @Override
    public void save(OAuth2Authorization authorization) {
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        this.authorizations.put(authorization.getId(), authorization);
    }

    @Override
    public void remove(OAuth2Authorization authorization) {
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        this.authorizations.remove(authorization.getId(), authorization);
    }

    @Override
    @Nullable
    public OAuth2Authorization findById(String id) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        return this.authorizations.get(id);
    }

    @Override
    @Nullable
    public OAuth2Authorization findByToken(String token, @Nullable OAuth2TokenType tokenType) {
        Assert.hasText((String)token, (String)"token cannot be empty");
        for (OAuth2Authorization authorization : this.authorizations.values()) {
            if (!InMemoryOAuth2AuthorizationService.hasToken(authorization, token, tokenType)) continue;
            return authorization;
        }
        return null;
    }

    private static boolean hasToken(OAuth2Authorization authorization, String token, @Nullable OAuth2TokenType tokenType) {
        if (tokenType == null) {
            return InMemoryOAuth2AuthorizationService.matchesState(authorization, token) || InMemoryOAuth2AuthorizationService.matchesAuthorizationCode(authorization, token) || InMemoryOAuth2AuthorizationService.matchesAccessToken(authorization, token) || InMemoryOAuth2AuthorizationService.matchesRefreshToken(authorization, token);
        }
        if ("state".equals(tokenType.getValue())) {
            return InMemoryOAuth2AuthorizationService.matchesState(authorization, token);
        }
        if ("code".equals(tokenType.getValue())) {
            return InMemoryOAuth2AuthorizationService.matchesAuthorizationCode(authorization, token);
        }
        if (OAuth2TokenType.ACCESS_TOKEN.equals(tokenType)) {
            return InMemoryOAuth2AuthorizationService.matchesAccessToken(authorization, token);
        }
        if (OAuth2TokenType.REFRESH_TOKEN.equals(tokenType)) {
            return InMemoryOAuth2AuthorizationService.matchesRefreshToken(authorization, token);
        }
        return false;
    }

    private static boolean matchesState(OAuth2Authorization authorization, String token) {
        return token.equals(authorization.getAttribute("state"));
    }

    private static boolean matchesAuthorizationCode(OAuth2Authorization authorization, String token) {
        OAuth2Authorization.Token<OAuth2AuthorizationCode> authorizationCode = authorization.getToken(OAuth2AuthorizationCode.class);
        return authorizationCode != null && authorizationCode.getToken().getTokenValue().equals(token);
    }

    private static boolean matchesAccessToken(OAuth2Authorization authorization, String token) {
        OAuth2Authorization.Token<OAuth2AccessToken> accessToken = authorization.getToken(OAuth2AccessToken.class);
        return accessToken != null && accessToken.getToken().getTokenValue().equals(token);
    }

    private static boolean matchesRefreshToken(OAuth2Authorization authorization, String token) {
        OAuth2Authorization.Token<OAuth2RefreshToken> refreshToken = authorization.getToken(OAuth2RefreshToken.class);
        return refreshToken != null && refreshToken.getToken().getTokenValue().equals(token);
    }
}

