/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.oauth2.core.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.core.oidc.http.converter.OidcClientRegistrationHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public final class OidcClientRegistrationEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OIDC_CLIENT_REGISTRATION_ENDPOINT_URI = "/connect/register";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher clientRegistrationEndpointMatcher;
    private final HttpMessageConverter<OidcClientRegistration> clientRegistrationHttpMessageConverter = new OidcClientRegistrationHttpMessageConverter();
    private final HttpMessageConverter<OAuth2Error> errorHttpResponseConverter = new OAuth2ErrorHttpMessageConverter();

    public OidcClientRegistrationEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_OIDC_CLIENT_REGISTRATION_ENDPOINT_URI);
    }

    public OidcClientRegistrationEndpointFilter(AuthenticationManager authenticationManager, String clientRegistrationEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)clientRegistrationEndpointUri, (String)"clientRegistrationEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.clientRegistrationEndpointMatcher = new AntPathRequestMatcher(clientRegistrationEndpointUri, HttpMethod.POST.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.clientRegistrationEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication principal = SecurityContextHolder.getContext().getAuthentication();
            OidcClientRegistration clientRegistration = (OidcClientRegistration)this.clientRegistrationHttpMessageConverter.read(OidcClientRegistration.class, (HttpInputMessage)new ServletServerHttpRequest(request));
            OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication = new OidcClientRegistrationAuthenticationToken(principal, clientRegistration);
            OidcClientRegistrationAuthenticationToken clientRegistrationAuthenticationResult = (OidcClientRegistrationAuthenticationToken)this.authenticationManager.authenticate((Authentication)clientRegistrationAuthentication);
            this.sendClientRegistrationResponse(response, clientRegistrationAuthenticationResult.getClientRegistration());
        }
        catch (OAuth2AuthenticationException ex) {
            this.sendErrorResponse(response, ex.getError());
        }
        catch (Exception ex) {
            OAuth2Error error = new OAuth2Error("invalid_request", "OpenID Client Registration Error: " + ex.getMessage(), "https://openid.net/specs/openid-connect-registration-1_0.html#RegistrationError");
            this.sendErrorResponse(response, error);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private void sendClientRegistrationResponse(HttpServletResponse response, OidcClientRegistration clientRegistration) throws IOException {
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode(HttpStatus.CREATED);
        this.clientRegistrationHttpMessageConverter.write((Object)clientRegistration, null, (HttpOutputMessage)httpResponse);
    }

    private void sendErrorResponse(HttpServletResponse response, OAuth2Error error) throws IOException {
        HttpStatus httpStatus = HttpStatus.BAD_REQUEST;
        if (error.getErrorCode().equals("invalid_token")) {
            httpStatus = HttpStatus.UNAUTHORIZED;
        } else if (error.getErrorCode().equals("insufficient_scope")) {
            httpStatus = HttpStatus.FORBIDDEN;
        }
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode(httpStatus);
        this.errorHttpResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
    }
}

