/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.util.HashSet;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration.RegisterMissingBeanPostProcessor;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration(proxyBeanMethods=false)
public class OAuth2AuthorizationServerConfiguration {
    @Bean
    @Order(value=-2147483648)
    public SecurityFilterChain authorizationServerSecurityFilterChain(HttpSecurity http) throws Exception {
        OAuth2AuthorizationServerConfiguration.applyDefaultSecurity(http);
        return (SecurityFilterChain)http.build();
    }

    public static void applyDefaultSecurity(HttpSecurity http) throws Exception {
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = new OAuth2AuthorizationServerConfigurer();
        RequestMatcher endpointsMatcher = authorizationServerConfigurer.getEndpointsMatcher();
        http.securityMatcher(endpointsMatcher).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated()).csrf(csrf -> csrf.ignoringRequestMatchers(new RequestMatcher[]{endpointsMatcher})).apply((SecurityConfigurerAdapter)authorizationServerConfigurer);
    }

    public static JwtDecoder jwtDecoder(JWKSource<SecurityContext> jwkSource) {
        HashSet jwsAlgs = new HashSet();
        jwsAlgs.addAll(JWSAlgorithm.Family.RSA);
        jwsAlgs.addAll(JWSAlgorithm.Family.EC);
        jwsAlgs.addAll(JWSAlgorithm.Family.HMAC_SHA);
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        JWSVerificationKeySelector jwsKeySelector = new JWSVerificationKeySelector(jwsAlgs, jwkSource);
        jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
        jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
        return new NimbusJwtDecoder((JWTProcessor)jwtProcessor);
    }

    @Bean
    RegisterMissingBeanPostProcessor registerMissingBeanPostProcessor() {
        RegisterMissingBeanPostProcessor postProcessor = new RegisterMissingBeanPostProcessor();
        postProcessor.addBeanDefinition(AuthorizationServerSettings.class, () -> AuthorizationServerSettings.builder().build());
        return postProcessor;
    }
}

