/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import jakarta.servlet.Filter;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.context.DelegatingApplicationListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AuthorizationServerContextFilter;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerMetadataEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ClientAuthenticationConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2DeviceAuthorizationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2DeviceVerificationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2TokenEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2TokenIntrospectionEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2TokenRevocationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.web.NimbusJwkSetEndpointFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OAuth2AuthorizationServerConfigurer
extends AbstractHttpConfigurer<OAuth2AuthorizationServerConfigurer, HttpSecurity> {
    private final Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = this.createConfigurers();
    private RequestMatcher endpointsMatcher;

    public OAuth2AuthorizationServerConfigurer registeredClientRepository(RegisteredClientRepository registeredClientRepository) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(RegisteredClientRepository.class, (Object)registeredClientRepository);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationService(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(OAuth2AuthorizationService.class, (Object)authorizationService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationConsentService(OAuth2AuthorizationConsentService authorizationConsentService) {
        Assert.notNull((Object)authorizationConsentService, (String)"authorizationConsentService cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(OAuth2AuthorizationConsentService.class, (Object)authorizationConsentService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationServerSettings(AuthorizationServerSettings authorizationServerSettings) {
        Assert.notNull((Object)authorizationServerSettings, (String)"authorizationServerSettings cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(AuthorizationServerSettings.class, (Object)authorizationServerSettings);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenGenerator(OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Assert.notNull(tokenGenerator, (String)"tokenGenerator cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(OAuth2TokenGenerator.class, tokenGenerator);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer clientAuthentication(Customizer<OAuth2ClientAuthenticationConfigurer> clientAuthenticationCustomizer) {
        clientAuthenticationCustomizer.customize((Object)this.getConfigurer(OAuth2ClientAuthenticationConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationServerMetadataEndpoint(Customizer<OAuth2AuthorizationServerMetadataEndpointConfigurer> authorizationServerMetadataEndpointCustomizer) {
        authorizationServerMetadataEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2AuthorizationServerMetadataEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationEndpoint(Customizer<OAuth2AuthorizationEndpointConfigurer> authorizationEndpointCustomizer) {
        authorizationEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2AuthorizationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenEndpoint(Customizer<OAuth2TokenEndpointConfigurer> tokenEndpointCustomizer) {
        tokenEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenIntrospectionEndpoint(Customizer<OAuth2TokenIntrospectionEndpointConfigurer> tokenIntrospectionEndpointCustomizer) {
        tokenIntrospectionEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenIntrospectionEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenRevocationEndpoint(Customizer<OAuth2TokenRevocationEndpointConfigurer> tokenRevocationEndpointCustomizer) {
        tokenRevocationEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenRevocationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer deviceAuthorizationEndpoint(Customizer<OAuth2DeviceAuthorizationEndpointConfigurer> deviceAuthorizationEndpointCustomizer) {
        deviceAuthorizationEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2DeviceAuthorizationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer deviceVerificationEndpoint(Customizer<OAuth2DeviceVerificationEndpointConfigurer> deviceVerificationEndpointCustomizer) {
        deviceVerificationEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2DeviceVerificationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer oidc(Customizer<OidcConfigurer> oidcCustomizer) {
        OidcConfigurer oidcConfigurer = this.getConfigurer(OidcConfigurer.class);
        if (oidcConfigurer == null) {
            this.addConfigurer(OidcConfigurer.class, new OidcConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
            oidcConfigurer = this.getConfigurer(OidcConfigurer.class);
        }
        oidcCustomizer.customize((Object)oidcConfigurer);
        return this;
    }

    public RequestMatcher getEndpointsMatcher() {
        return request -> this.endpointsMatcher.matches(request);
    }

    public void init(HttpSecurity httpSecurity) {
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        OAuth2AuthorizationServerConfigurer.validateAuthorizationServerSettings(authorizationServerSettings);
        if (this.isOidcEnabled()) {
            OAuth2AuthorizationServerConfigurer.initSessionRegistry(httpSecurity);
            SessionRegistry sessionRegistry = (SessionRegistry)httpSecurity.getSharedObject(SessionRegistry.class);
            OAuth2AuthorizationEndpointConfigurer authorizationEndpointConfigurer = this.getConfigurer(OAuth2AuthorizationEndpointConfigurer.class);
            authorizationEndpointConfigurer.setSessionAuthenticationStrategy((authentication, request, response) -> {
                OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication;
                if (authentication instanceof OAuth2AuthorizationCodeRequestAuthenticationToken && (authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication).getScopes().contains("openid") && sessionRegistry.getSessionInformation(request.getSession().getId()) == null) {
                    sessionRegistry.registerNewSession(request.getSession().getId(), ((Authentication)authorizationCodeRequestAuthentication.getPrincipal()).getPrincipal());
                }
            });
        } else {
            OAuth2AuthorizationEndpointConfigurer authorizationEndpointConfigurer = this.getConfigurer(OAuth2AuthorizationEndpointConfigurer.class);
            authorizationEndpointConfigurer.addAuthorizationCodeRequestAuthenticationValidator(authenticationContext -> {
                OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)((Object)((Object)authenticationContext.getAuthentication()));
                if (authorizationCodeRequestAuthentication.getScopes().contains("openid")) {
                    OAuth2Error error = new OAuth2Error("invalid_scope", "OpenID Connect 1.0 authentication requests are restricted.", "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1");
                    throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, authorizationCodeRequestAuthentication);
                }
            });
        }
        ArrayList<AntPathRequestMatcher> requestMatchers = new ArrayList<AntPathRequestMatcher>();
        this.configurers.values().forEach(configurer -> {
            configurer.init(httpSecurity);
            requestMatchers.add((AntPathRequestMatcher)configurer.getRequestMatcher());
        });
        requestMatchers.add(new AntPathRequestMatcher(authorizationServerSettings.getJwkSetEndpoint(), HttpMethod.GET.name()));
        this.endpointsMatcher = new OrRequestMatcher(requestMatchers);
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)httpSecurity.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{this.getRequestMatcher(OAuth2TokenEndpointConfigurer.class), this.getRequestMatcher(OAuth2TokenIntrospectionEndpointConfigurer.class), this.getRequestMatcher(OAuth2TokenRevocationEndpointConfigurer.class), this.getRequestMatcher(OAuth2DeviceAuthorizationEndpointConfigurer.class)}));
        }
    }

    public void configure(HttpSecurity httpSecurity) {
        this.configurers.values().forEach(configurer -> configurer.configure(httpSecurity));
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        AuthorizationServerContextFilter authorizationServerContextFilter = new AuthorizationServerContextFilter(authorizationServerSettings);
        httpSecurity.addFilterAfter((Filter)this.postProcess((Object)authorizationServerContextFilter), SecurityContextHolderFilter.class);
        JWKSource<SecurityContext> jwkSource = OAuth2ConfigurerUtils.getJwkSource(httpSecurity);
        if (jwkSource != null) {
            NimbusJwkSetEndpointFilter jwkSetEndpointFilter = new NimbusJwkSetEndpointFilter(jwkSource, authorizationServerSettings.getJwkSetEndpoint());
            httpSecurity.addFilterBefore((Filter)this.postProcess((Object)jwkSetEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
        }
    }

    private boolean isOidcEnabled() {
        return this.getConfigurer(OidcConfigurer.class) != null;
    }

    private Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> createConfigurers() {
        LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = new LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer>();
        configurers.put(OAuth2ClientAuthenticationConfigurer.class, new OAuth2ClientAuthenticationConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
        configurers.put(OAuth2AuthorizationServerMetadataEndpointConfigurer.class, new OAuth2AuthorizationServerMetadataEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
        configurers.put(OAuth2AuthorizationEndpointConfigurer.class, new OAuth2AuthorizationEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
        configurers.put(OAuth2TokenEndpointConfigurer.class, new OAuth2TokenEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
        configurers.put(OAuth2TokenIntrospectionEndpointConfigurer.class, new OAuth2TokenIntrospectionEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
        configurers.put(OAuth2TokenRevocationEndpointConfigurer.class, new OAuth2TokenRevocationEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
        configurers.put(OAuth2DeviceAuthorizationEndpointConfigurer.class, new OAuth2DeviceAuthorizationEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
        configurers.put(OAuth2DeviceVerificationEndpointConfigurer.class, new OAuth2DeviceVerificationEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)x$0 -> this.postProcess(x$0))));
        return configurers;
    }

    private <T> T getConfigurer(Class<T> type) {
        return (T)this.configurers.get(type);
    }

    private <T extends AbstractOAuth2Configurer> void addConfigurer(Class<T> configurerType, T configurer) {
        this.configurers.put(configurerType, configurer);
    }

    private <T extends AbstractOAuth2Configurer> RequestMatcher getRequestMatcher(Class<T> configurerType) {
        AbstractOAuth2Configurer configurer = (AbstractOAuth2Configurer)this.getConfigurer(configurerType);
        return configurer != null ? configurer.getRequestMatcher() : null;
    }

    private static void validateAuthorizationServerSettings(AuthorizationServerSettings authorizationServerSettings) {
        if (authorizationServerSettings.getIssuer() != null) {
            URI issuerUri;
            try {
                issuerUri = new URI(authorizationServerSettings.getIssuer());
                issuerUri.toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("issuer must be a valid URL", ex);
            }
            if (issuerUri.getQuery() != null || issuerUri.getFragment() != null) {
                throw new IllegalArgumentException("issuer cannot contain query or fragment component");
            }
        }
    }

    private static void initSessionRegistry(HttpSecurity httpSecurity) {
        SessionRegistry sessionRegistry = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, SessionRegistry.class);
        if (sessionRegistry == null) {
            sessionRegistry = new SessionRegistryImpl();
            OAuth2AuthorizationServerConfigurer.registerDelegateApplicationListener(httpSecurity, (SessionRegistryImpl)sessionRegistry);
        }
        httpSecurity.setSharedObject(SessionRegistry.class, (Object)sessionRegistry);
    }

    private static void registerDelegateApplicationListener(HttpSecurity httpSecurity, ApplicationListener<?> delegate) {
        DelegatingApplicationListener delegatingApplicationListener = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, DelegatingApplicationListener.class);
        if (delegatingApplicationListener == null) {
            return;
        }
        GenericApplicationListenerAdapter smartListener = new GenericApplicationListenerAdapter(delegate);
        delegatingApplicationListener.addListener((SmartApplicationListener)smartListener);
    }
}

