/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.time.Instant;
import java.util.Base64;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;

final class OAuth2PushedAuthorizationRequestUri {
    private static final String REQUEST_URI_PREFIX = "urn:ietf:params:oauth:request_uri:";
    private static final String REQUEST_URI_DELIMITER = "___";
    private static final StringKeyGenerator DEFAULT_STATE_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder());
    private String requestUri;
    private String state;
    private Instant expiresAt;

    static OAuth2PushedAuthorizationRequestUri create() {
        return OAuth2PushedAuthorizationRequestUri.create(Instant.now().plusSeconds(30L));
    }

    static OAuth2PushedAuthorizationRequestUri create(Instant expiresAt) {
        String state = DEFAULT_STATE_GENERATOR.generateKey();
        OAuth2PushedAuthorizationRequestUri pushedAuthorizationRequestUri = new OAuth2PushedAuthorizationRequestUri();
        pushedAuthorizationRequestUri.requestUri = REQUEST_URI_PREFIX + state + REQUEST_URI_DELIMITER + expiresAt.toEpochMilli();
        pushedAuthorizationRequestUri.state = state + REQUEST_URI_DELIMITER + expiresAt.toEpochMilli();
        pushedAuthorizationRequestUri.expiresAt = expiresAt;
        return pushedAuthorizationRequestUri;
    }

    static OAuth2PushedAuthorizationRequestUri parse(String requestUri) {
        int stateStartIndex = REQUEST_URI_PREFIX.length();
        int expiresAtStartIndex = requestUri.indexOf(REQUEST_URI_DELIMITER) + REQUEST_URI_DELIMITER.length();
        OAuth2PushedAuthorizationRequestUri pushedAuthorizationRequestUri = new OAuth2PushedAuthorizationRequestUri();
        pushedAuthorizationRequestUri.requestUri = requestUri;
        pushedAuthorizationRequestUri.state = requestUri.substring(stateStartIndex);
        pushedAuthorizationRequestUri.expiresAt = Instant.ofEpochMilli(Long.parseLong(requestUri.substring(expiresAtStartIndex)));
        return pushedAuthorizationRequestUri;
    }

    String getRequestUri() {
        return this.requestUri;
    }

    String getState() {
        return this.state;
    }

    Instant getExpiresAt() {
        return this.expiresAt;
    }

    private OAuth2PushedAuthorizationRequestUri() {
    }
}

