/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.util.SpringAuthorizationServerVersion;
import org.springframework.util.Assert;

abstract class AbstractOAuth2AuthorizationCodeRequestAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = SpringAuthorizationServerVersion.SERIAL_VERSION_UID;
    private final String authorizationUri;
    private final String clientId;
    private final Authentication principal;
    private final String redirectUri;
    private final String state;
    private final Set<String> scopes;
    private final Map<String, Object> additionalParameters;

    protected AbstractOAuth2AuthorizationCodeRequestAuthenticationToken(String authorizationUri, String clientId, Authentication principal, @Nullable String redirectUri, @Nullable String state, @Nullable Set<String> scopes, @Nullable Map<String, Object> additionalParameters) {
        super(Collections.emptyList());
        Assert.hasText((String)authorizationUri, (String)"authorizationUri cannot be empty");
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        this.authorizationUri = authorizationUri;
        this.clientId = clientId;
        this.principal = principal;
        this.redirectUri = redirectUri;
        this.state = state;
        this.scopes = Collections.unmodifiableSet(scopes != null ? new HashSet<String>(scopes) : Collections.emptySet());
        this.additionalParameters = Collections.unmodifiableMap(additionalParameters != null ? new HashMap<String, Object>(additionalParameters) : Collections.emptyMap());
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }
}

