/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationToken;
import org.springframework.util.Assert;

public class OAuth2DeviceAuthorizationConsentAuthenticationToken
extends OAuth2AuthorizationConsentAuthenticationToken {
    private static final long serialVersionUID = 3789252233721827596L;
    private final String userCode;
    private final Set<String> requestedScopes;

    public OAuth2DeviceAuthorizationConsentAuthenticationToken(String authorizationUri, String clientId, Authentication principal, String userCode, String state, @Nullable Set<String> authorizedScopes, @Nullable Map<String, Object> additionalParameters) {
        super(authorizationUri, clientId, principal, state, authorizedScopes, additionalParameters);
        Assert.hasText((String)userCode, (String)"userCode cannot be empty");
        this.userCode = userCode;
        this.requestedScopes = null;
        this.setAuthenticated(false);
    }

    public OAuth2DeviceAuthorizationConsentAuthenticationToken(String authorizationUri, String clientId, Authentication principal, String userCode, String state, @Nullable Set<String> requestedScopes, @Nullable Set<String> authorizedScopes) {
        super(authorizationUri, clientId, principal, state, authorizedScopes, null);
        Assert.hasText((String)userCode, (String)"userCode cannot be empty");
        this.userCode = userCode;
        this.requestedScopes = Collections.unmodifiableSet(requestedScopes != null ? new HashSet<String>(requestedScopes) : Collections.emptySet());
        this.setAuthenticated(true);
    }

    public String getUserCode() {
        return this.userCode;
    }

    public Set<String> getRequestedScopes() {
        return this.requestedScopes;
    }
}

