/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.authentication;

import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoderJwkSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OidcAuthorizationCodeAuthenticationProvider
implements AuthenticationProvider {
    private static final String INVALID_STATE_PARAMETER_ERROR_CODE = "invalid_state_parameter";
    private static final String INVALID_REDIRECT_URI_PARAMETER_ERROR_CODE = "invalid_redirect_uri_parameter";
    private static final String INVALID_ID_TOKEN_ERROR_CODE = "invalid_id_token";
    private static final String MISSING_SIGNATURE_VERIFIER_ERROR_CODE = "missing_signature_verifier";
    private final OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;
    private final OAuth2UserService<OidcUserRequest, OidcUser> userService;
    private final Map<String, JwtDecoder> jwtDecoders = new ConcurrentHashMap<String, JwtDecoder>();
    private GrantedAuthoritiesMapper authoritiesMapper = authorities -> authorities;

    public OidcAuthorizationCodeAuthenticationProvider(OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient, OAuth2UserService<OidcUserRequest, OidcUser> userService) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        Assert.notNull(userService, (String)"userService cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
        this.userService = userService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2LoginAuthenticationToken authorizationCodeAuthentication = (OAuth2LoginAuthenticationToken)authentication;
        if (!authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest().getScopes().contains("openid")) {
            return null;
        }
        OAuth2AuthorizationRequest authorizationRequest = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest();
        OAuth2AuthorizationResponse authorizationResponse = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationResponse();
        if (authorizationResponse.statusError()) {
            throw new OAuth2AuthenticationException(authorizationResponse.getError(), authorizationResponse.getError().toString());
        }
        if (!authorizationResponse.getState().equals(authorizationRequest.getState())) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_STATE_PARAMETER_ERROR_CODE);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
        if (!authorizationResponse.getRedirectUri().equals(authorizationRequest.getRedirectUri())) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_REDIRECT_URI_PARAMETER_ERROR_CODE);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
        OAuth2AccessTokenResponse accessTokenResponse = this.accessTokenResponseClient.getTokenResponse(new OAuth2AuthorizationCodeGrantRequest(authorizationCodeAuthentication.getClientRegistration(), authorizationCodeAuthentication.getAuthorizationExchange()));
        OAuth2AccessToken accessToken = accessTokenResponse.getAccessToken();
        ClientRegistration clientRegistration = authorizationCodeAuthentication.getClientRegistration();
        if (!accessTokenResponse.getAdditionalParameters().containsKey("id_token")) {
            OAuth2Error invalidIdTokenError = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, "Missing (required) ID Token in Token Response for Client Registration: " + clientRegistration.getRegistrationId(), null);
            throw new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString());
        }
        JwtDecoder jwtDecoder = this.getJwtDecoder(clientRegistration);
        Jwt jwt = jwtDecoder.decode((String)accessTokenResponse.getAdditionalParameters().get("id_token"));
        OidcIdToken idToken = new OidcIdToken(jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt(), jwt.getClaims());
        this.validateIdToken(idToken, clientRegistration);
        OidcUser oidcUser = this.userService.loadUser(new OidcUserRequest(clientRegistration, accessToken, idToken));
        Collection mappedAuthorities = this.authoritiesMapper.mapAuthorities(oidcUser.getAuthorities());
        OAuth2LoginAuthenticationToken authenticationResult = new OAuth2LoginAuthenticationToken(authorizationCodeAuthentication.getClientRegistration(), authorizationCodeAuthentication.getAuthorizationExchange(), (OAuth2User)oidcUser, mappedAuthorities, accessToken);
        authenticationResult.setDetails(authorizationCodeAuthentication.getDetails());
        return authenticationResult;
    }

    public final void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        Assert.notNull((Object)authoritiesMapper, (String)"authoritiesMapper cannot be null");
        this.authoritiesMapper = authoritiesMapper;
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2LoginAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private JwtDecoder getJwtDecoder(ClientRegistration clientRegistration) {
        JwtDecoder jwtDecoder = this.jwtDecoders.get(clientRegistration.getRegistrationId());
        if (jwtDecoder == null) {
            if (!StringUtils.hasText((String)clientRegistration.getProviderDetails().getJwkSetUri())) {
                OAuth2Error oauth2Error = new OAuth2Error(MISSING_SIGNATURE_VERIFIER_ERROR_CODE, "Failed to find a Signature Verifier for Client Registration: '" + clientRegistration.getRegistrationId() + "'. Check to ensure you have configured the JwkSet URI.", null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            jwtDecoder = new NimbusJwtDecoderJwkSupport(clientRegistration.getProviderDetails().getJwkSetUri());
            this.jwtDecoders.put(clientRegistration.getRegistrationId(), jwtDecoder);
        }
        return jwtDecoder;
    }

    private void validateIdToken(OidcIdToken idToken, ClientRegistration clientRegistration) {
        Instant maxIssuedAt;
        Instant now;
        Instant issuedAt;
        Instant expiresAt;
        List audience;
        String subject;
        URL issuer = idToken.getIssuer();
        if (issuer == null) {
            this.throwInvalidIdTokenException();
        }
        if ((subject = idToken.getSubject()) == null) {
            this.throwInvalidIdTokenException();
        }
        if (CollectionUtils.isEmpty((Collection)(audience = idToken.getAudience()))) {
            this.throwInvalidIdTokenException();
        }
        if ((expiresAt = idToken.getExpiresAt()) == null) {
            this.throwInvalidIdTokenException();
        }
        if ((issuedAt = idToken.getIssuedAt()) == null) {
            this.throwInvalidIdTokenException();
        }
        if (!audience.contains(clientRegistration.getClientId())) {
            this.throwInvalidIdTokenException();
        }
        String authorizedParty = idToken.getAuthorizedParty();
        if (audience.size() > 1 && authorizedParty == null) {
            this.throwInvalidIdTokenException();
        }
        if (authorizedParty != null && !authorizedParty.equals(clientRegistration.getClientId())) {
            this.throwInvalidIdTokenException();
        }
        if (!(now = Instant.now()).isBefore(expiresAt)) {
            this.throwInvalidIdTokenException();
        }
        if (issuedAt.isAfter(maxIssuedAt = now.plusSeconds(30L))) {
            this.throwInvalidIdTokenException();
        }
    }

    private void throwInvalidIdTokenException() {
        OAuth2Error invalidIdTokenError = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE);
        throw new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString());
    }
}

