/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.userinfo;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.oauth2.client.userinfo.NimbusUserInfoResponseClient;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;

public class CustomUserTypesOAuth2UserService
implements OAuth2UserService<OAuth2UserRequest, OAuth2User> {
    private final Map<String, Class<? extends OAuth2User>> customUserTypes;
    private NimbusUserInfoResponseClient userInfoResponseClient = new NimbusUserInfoResponseClient();

    public CustomUserTypesOAuth2UserService(Map<String, Class<? extends OAuth2User>> customUserTypes) {
        Assert.notEmpty(customUserTypes, (String)"customUserTypes cannot be empty");
        this.customUserTypes = Collections.unmodifiableMap(new LinkedHashMap<String, Class<? extends OAuth2User>>(customUserTypes));
    }

    @Override
    public OAuth2User loadUser(OAuth2UserRequest userRequest) throws OAuth2AuthenticationException {
        String registrationId = userRequest.getClientRegistration().getRegistrationId();
        Class<? extends OAuth2User> customUserType = this.customUserTypes.get(registrationId);
        if (customUserType == null) {
            return null;
        }
        return this.userInfoResponseClient.getUserInfoResponse(userRequest, customUserType);
    }
}

