/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class DefaultReactiveOAuth2AuthorizedClientManager
implements ReactiveOAuth2AuthorizedClientManager {
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private final ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
    private ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = context -> Mono.empty();
    private Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> contextAttributesMapper = new DefaultContextAttributesMapper();

    public DefaultReactiveOAuth2AuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientRepository = authorizedClientRepository;
    }

    @Override
    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizeRequest authorizeRequest) {
        Assert.notNull((Object)authorizeRequest, (String)"authorizeRequest cannot be null");
        String clientRegistrationId = authorizeRequest.getClientRegistrationId();
        Authentication principal = authorizeRequest.getPrincipal();
        ServerWebExchange serverWebExchange = (ServerWebExchange)authorizeRequest.getAttribute(ServerWebExchange.class.getName());
        Assert.notNull((Object)serverWebExchange, (String)"serverWebExchange cannot be null");
        return Mono.justOrEmpty((Object)authorizeRequest.getAuthorizedClient()).switchIfEmpty(Mono.defer(() -> this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal, serverWebExchange))).flatMap(authorizedClient -> this.authorizationContext(authorizeRequest, (OAuth2AuthorizedClient)authorizedClient).flatMap(this.authorizedClientProvider::authorize).doOnNext(reauthorizedClient -> this.authorizedClientRepository.saveAuthorizedClient((OAuth2AuthorizedClient)reauthorizedClient, principal, serverWebExchange)).defaultIfEmpty((Object)(authorizeRequest.getAuthorizedClient() != null ? authorizeRequest.getAuthorizedClient() : authorizedClient))).switchIfEmpty(Mono.defer(() -> this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("Could not find ClientRegistration with id '" + clientRegistrationId + "'"))).flatMap(clientRegistration -> this.authorizationContext(authorizeRequest, (ClientRegistration)clientRegistration)).flatMap(this.authorizedClientProvider::authorize).doOnNext(authorizedClient -> this.authorizedClientRepository.saveAuthorizedClient((OAuth2AuthorizedClient)authorizedClient, principal, serverWebExchange))));
    }

    private Mono<OAuth2AuthorizationContext> authorizationContext(OAuth2AuthorizeRequest authorizeRequest, OAuth2AuthorizedClient authorizedClient) {
        return Mono.just((Object)authorizeRequest).flatMap(this.contextAttributesMapper::apply).map(attrs -> OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient).principal(authorizeRequest.getPrincipal()).attributes(attributes -> {
            if (!CollectionUtils.isEmpty((Map)attrs)) {
                attributes.putAll(attrs);
            }
        }).build());
    }

    private Mono<OAuth2AuthorizationContext> authorizationContext(OAuth2AuthorizeRequest authorizeRequest, ClientRegistration clientRegistration) {
        return Mono.just((Object)authorizeRequest).flatMap(this.contextAttributesMapper::apply).map(attrs -> OAuth2AuthorizationContext.withClientRegistration(clientRegistration).principal(authorizeRequest.getPrincipal()).attributes(attributes -> {
            if (!CollectionUtils.isEmpty((Map)attrs)) {
                attributes.putAll(attrs);
            }
        }).build());
    }

    public void setAuthorizedClientProvider(ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider) {
        Assert.notNull((Object)authorizedClientProvider, (String)"authorizedClientProvider cannot be null");
        this.authorizedClientProvider = authorizedClientProvider;
    }

    public void setContextAttributesMapper(Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> contextAttributesMapper) {
        Assert.notNull(contextAttributesMapper, (String)"contextAttributesMapper cannot be null");
        this.contextAttributesMapper = contextAttributesMapper;
    }

    public static class DefaultContextAttributesMapper
    implements Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> {
        @Override
        public Mono<Map<String, Object>> apply(OAuth2AuthorizeRequest authorizeRequest) {
            Map<String, String[]> contextAttributes = Collections.emptyMap();
            ServerWebExchange serverWebExchange = (ServerWebExchange)authorizeRequest.getAttribute(ServerWebExchange.class.getName());
            String scope = (String)serverWebExchange.getRequest().getQueryParams().getFirst((Object)"scope");
            if (StringUtils.hasText((String)scope)) {
                contextAttributes = new HashMap();
                contextAttributes.put(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME, StringUtils.delimitedListToStringArray((String)scope, (String)" "));
            }
            return Mono.just(contextAttributes);
        }
    }
}

