/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.function.client;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;

public final class ServletOAuth2AuthorizedClientExchangeFilterFunction
implements ExchangeFilterFunction,
InitializingBean,
DisposableBean {
    private static final String OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME = OAuth2AuthorizedClient.class.getName();
    private static final String CLIENT_REGISTRATION_ID_ATTR_NAME = OAuth2AuthorizedClient.class.getName().concat(".CLIENT_REGISTRATION_ID");
    private static final String AUTHENTICATION_ATTR_NAME = Authentication.class.getName();
    private static final String HTTP_SERVLET_REQUEST_ATTR_NAME = HttpServletRequest.class.getName();
    private static final String HTTP_SERVLET_RESPONSE_ATTR_NAME = HttpServletResponse.class.getName();
    private static final String REQUEST_CONTEXT_OPERATOR_KEY = RequestContextSubscriber.class.getName();
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    @Deprecated
    private Duration accessTokenExpiresSkew = Duration.ofMinutes(1L);
    @Deprecated
    private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;
    private OAuth2AuthorizedClientManager authorizedClientManager;
    private boolean defaultAuthorizedClientManager;
    private boolean defaultOAuth2AuthorizedClient;
    private String defaultClientRegistrationId;

    public ServletOAuth2AuthorizedClientExchangeFilterFunction() {
    }

    public ServletOAuth2AuthorizedClientExchangeFilterFunction(OAuth2AuthorizedClientManager authorizedClientManager) {
        Assert.notNull((Object)authorizedClientManager, (String)"authorizedClientManager cannot be null");
        this.authorizedClientManager = authorizedClientManager;
    }

    public ServletOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        this.authorizedClientManager = ServletOAuth2AuthorizedClientExchangeFilterFunction.createDefaultAuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        this.defaultAuthorizedClientManager = true;
    }

    private static OAuth2AuthorizedClientManager createDefaultAuthorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().build();
        DefaultOAuth2AuthorizedClientManager authorizedClientManager = new DefaultOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        return authorizedClientManager;
    }

    public void afterPropertiesSet() throws Exception {
        Hooks.onLastOperator((String)REQUEST_CONTEXT_OPERATOR_KEY, (Function)Operators.liftPublisher((s, sub) -> this.createRequestContextSubscriberIfNecessary((CoreSubscriber)sub)));
    }

    public void destroy() throws Exception {
        Hooks.resetOnLastOperator((String)REQUEST_CONTEXT_OPERATOR_KEY);
    }

    @Deprecated
    public void setClientCredentialsTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient) {
        Assert.notNull(clientCredentialsTokenResponseClient, (String)"clientCredentialsTokenResponseClient cannot be null");
        Assert.state((boolean)this.defaultAuthorizedClientManager, (String)"The client cannot be set when the constructor used is \"ServletOAuth2AuthorizedClientExchangeFilterFunction(OAuth2AuthorizedClientManager)\". Instead, use the constructor \"ServletOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository, OAuth2AuthorizedClientRepository)\".");
        this.clientCredentialsTokenResponseClient = clientCredentialsTokenResponseClient;
        this.updateDefaultAuthorizedClientManager();
    }

    private void updateDefaultAuthorizedClientManager() {
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken(configurer -> configurer.clockSkew(this.accessTokenExpiresSkew)).clientCredentials(this::updateClientCredentialsProvider).password(configurer -> configurer.clockSkew(this.accessTokenExpiresSkew)).build();
        ((DefaultOAuth2AuthorizedClientManager)this.authorizedClientManager).setAuthorizedClientProvider(authorizedClientProvider);
    }

    private void updateClientCredentialsProvider(OAuth2AuthorizedClientProviderBuilder.ClientCredentialsGrantBuilder builder) {
        if (this.clientCredentialsTokenResponseClient != null) {
            builder.accessTokenResponseClient(this.clientCredentialsTokenResponseClient);
        }
        builder.clockSkew(this.accessTokenExpiresSkew);
    }

    public void setDefaultOAuth2AuthorizedClient(boolean defaultOAuth2AuthorizedClient) {
        this.defaultOAuth2AuthorizedClient = defaultOAuth2AuthorizedClient;
    }

    public void setDefaultClientRegistrationId(String clientRegistrationId) {
        this.defaultClientRegistrationId = clientRegistrationId;
    }

    public Consumer<WebClient.Builder> oauth2Configuration() {
        return builder -> builder.defaultRequest(this.defaultRequest()).filter((ExchangeFilterFunction)this);
    }

    public Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest() {
        return spec -> spec.attributes(attrs -> {
            this.populateDefaultRequestResponse((Map<String, Object>)attrs);
            this.populateDefaultAuthentication((Map<String, Object>)attrs);
        });
    }

    public static Consumer<Map<String, Object>> oauth2AuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        return attributes -> {
            if (authorizedClient == null) {
                attributes.remove(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME);
            } else {
                attributes.put(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME, authorizedClient);
            }
        };
    }

    public static Consumer<Map<String, Object>> clientRegistrationId(String clientRegistrationId) {
        return attributes -> attributes.put(CLIENT_REGISTRATION_ID_ATTR_NAME, clientRegistrationId);
    }

    public static Consumer<Map<String, Object>> authentication(Authentication authentication) {
        return attributes -> attributes.put(AUTHENTICATION_ATTR_NAME, authentication);
    }

    public static Consumer<Map<String, Object>> httpServletRequest(HttpServletRequest request) {
        return attributes -> attributes.put(HTTP_SERVLET_REQUEST_ATTR_NAME, request);
    }

    public static Consumer<Map<String, Object>> httpServletResponse(HttpServletResponse response) {
        return attributes -> attributes.put(HTTP_SERVLET_RESPONSE_ATTR_NAME, response);
    }

    @Deprecated
    public void setAccessTokenExpiresSkew(Duration accessTokenExpiresSkew) {
        Assert.notNull((Object)accessTokenExpiresSkew, (String)"accessTokenExpiresSkew cannot be null");
        Assert.state((boolean)this.defaultAuthorizedClientManager, (String)"The accessTokenExpiresSkew cannot be set when the constructor used is \"ServletOAuth2AuthorizedClientExchangeFilterFunction(OAuth2AuthorizedClientManager)\". Instead, use the constructor \"ServletOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository, OAuth2AuthorizedClientRepository)\".");
        this.accessTokenExpiresSkew = accessTokenExpiresSkew;
        this.updateDefaultAuthorizedClientManager();
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return this.mergeRequestAttributesIfNecessary(request).filter(req -> req.attribute(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME).isPresent()).flatMap(req -> this.authorizedClient(ServletOAuth2AuthorizedClientExchangeFilterFunction.getOAuth2AuthorizedClient(req.attributes()), (ClientRequest)req)).switchIfEmpty(Mono.defer(() -> this.mergeRequestAttributesIfNecessary(request).filter(req -> this.resolveClientRegistrationId((ClientRequest)req) != null).flatMap(req -> this.authorizeClient(this.resolveClientRegistrationId((ClientRequest)req), (ClientRequest)req)))).map(authorizedClient -> this.bearer(request, (OAuth2AuthorizedClient)authorizedClient)).flatMap(arg_0 -> ((ExchangeFunction)next).exchange(arg_0)).switchIfEmpty(Mono.defer(() -> next.exchange(request)));
    }

    private Mono<ClientRequest> mergeRequestAttributesIfNecessary(ClientRequest request) {
        if (!(request.attribute(HTTP_SERVLET_REQUEST_ATTR_NAME).isPresent() && request.attribute(HTTP_SERVLET_RESPONSE_ATTR_NAME).isPresent() && request.attribute(AUTHENTICATION_ATTR_NAME).isPresent())) {
            return this.mergeRequestAttributesFromContext(request);
        }
        return Mono.just((Object)request);
    }

    private Mono<ClientRequest> mergeRequestAttributesFromContext(ClientRequest request) {
        ClientRequest.Builder builder = ClientRequest.from((ClientRequest)request);
        return Mono.subscriberContext().map(ctx -> builder.attributes(attrs -> this.populateRequestAttributes((Map<String, Object>)attrs, (Context)ctx))).map(ClientRequest.Builder::build);
    }

    private void populateRequestAttributes(Map<String, Object> attrs, Context ctx) {
        RequestContextDataHolder holder = RequestContextSubscriber.getRequestContext(ctx);
        if (holder != null) {
            Authentication authentication;
            HttpServletResponse response;
            HttpServletRequest request = holder.getRequest();
            if (request != null) {
                attrs.putIfAbsent(HTTP_SERVLET_REQUEST_ATTR_NAME, request);
            }
            if ((response = holder.getResponse()) != null) {
                attrs.putIfAbsent(HTTP_SERVLET_RESPONSE_ATTR_NAME, response);
            }
            if ((authentication = holder.getAuthentication()) != null) {
                attrs.putIfAbsent(AUTHENTICATION_ATTR_NAME, authentication);
            }
        }
    }

    private void populateDefaultRequestResponse(Map<String, Object> attrs) {
        if (attrs.containsKey(HTTP_SERVLET_REQUEST_ATTR_NAME) && attrs.containsKey(HTTP_SERVLET_RESPONSE_ATTR_NAME)) {
            return;
        }
        ServletRequestAttributes context = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        if (context != null) {
            request = context.getRequest();
            response = context.getResponse();
        }
        attrs.putIfAbsent(HTTP_SERVLET_REQUEST_ATTR_NAME, request);
        attrs.putIfAbsent(HTTP_SERVLET_RESPONSE_ATTR_NAME, response);
    }

    private void populateDefaultAuthentication(Map<String, Object> attrs) {
        if (attrs.containsKey(AUTHENTICATION_ATTR_NAME)) {
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        attrs.putIfAbsent(AUTHENTICATION_ATTR_NAME, authentication);
    }

    private String resolveClientRegistrationId(ClientRequest request) {
        Map attrs = request.attributes();
        String clientRegistrationId = ServletOAuth2AuthorizedClientExchangeFilterFunction.getClientRegistrationId(attrs);
        if (clientRegistrationId == null) {
            clientRegistrationId = this.defaultClientRegistrationId;
        }
        Authentication authentication = ServletOAuth2AuthorizedClientExchangeFilterFunction.getAuthentication(attrs);
        if (clientRegistrationId == null && this.defaultOAuth2AuthorizedClient && authentication instanceof OAuth2AuthenticationToken) {
            clientRegistrationId = ((OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId();
        }
        return clientRegistrationId;
    }

    private Mono<OAuth2AuthorizedClient> authorizeClient(String clientRegistrationId, ClientRequest request) {
        if (this.authorizedClientManager == null) {
            return Mono.empty();
        }
        Map attrs = request.attributes();
        Authentication authentication = ServletOAuth2AuthorizedClientExchangeFilterFunction.getAuthentication(attrs);
        if (authentication == null) {
            authentication = ANONYMOUS_AUTHENTICATION;
        }
        HttpServletRequest servletRequest = ServletOAuth2AuthorizedClientExchangeFilterFunction.getRequest(attrs);
        HttpServletResponse servletResponse = ServletOAuth2AuthorizedClientExchangeFilterFunction.getResponse(attrs);
        OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withClientRegistrationId(clientRegistrationId).principal(authentication);
        builder.attributes(attributes -> {
            if (servletRequest != null) {
                attributes.put(HttpServletRequest.class.getName(), servletRequest);
            }
            if (servletResponse != null) {
                attributes.put(HttpServletResponse.class.getName(), servletResponse);
            }
        });
        OAuth2AuthorizeRequest authorizeRequest = builder.build();
        return Mono.fromSupplier(() -> this.authorizedClientManager.authorize(authorizeRequest)).subscribeOn(Schedulers.elastic());
    }

    private Mono<OAuth2AuthorizedClient> authorizedClient(OAuth2AuthorizedClient authorizedClient, ClientRequest request) {
        if (this.authorizedClientManager == null) {
            return Mono.just((Object)authorizedClient);
        }
        Map attrs = request.attributes();
        Authentication authentication = ServletOAuth2AuthorizedClientExchangeFilterFunction.getAuthentication(attrs);
        if (authentication == null) {
            authentication = new PrincipalNameAuthentication(authorizedClient.getPrincipalName());
        }
        HttpServletRequest servletRequest = ServletOAuth2AuthorizedClientExchangeFilterFunction.getRequest(attrs);
        HttpServletResponse servletResponse = ServletOAuth2AuthorizedClientExchangeFilterFunction.getResponse(attrs);
        OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withAuthorizedClient(authorizedClient).principal(authentication);
        builder.attributes(attributes -> {
            if (servletRequest != null) {
                attributes.put(HttpServletRequest.class.getName(), servletRequest);
            }
            if (servletResponse != null) {
                attributes.put(HttpServletResponse.class.getName(), servletResponse);
            }
        });
        OAuth2AuthorizeRequest reauthorizeRequest = builder.build();
        return Mono.fromSupplier(() -> this.authorizedClientManager.authorize(reauthorizeRequest)).subscribeOn(Schedulers.elastic());
    }

    private ClientRequest bearer(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        return ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(authorizedClient.getAccessToken().getTokenValue())).build();
    }

    <T> CoreSubscriber<T> createRequestContextSubscriberIfNecessary(CoreSubscriber<T> delegate) {
        Authentication authentication;
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            request = requestAttributes.getRequest();
            response = requestAttributes.getResponse();
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) == null && request == null && response == null) {
            return delegate;
        }
        return new RequestContextSubscriber<T>(delegate, request, response, authentication);
    }

    static OAuth2AuthorizedClient getOAuth2AuthorizedClient(Map<String, Object> attrs) {
        return (OAuth2AuthorizedClient)attrs.get(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME);
    }

    static String getClientRegistrationId(Map<String, Object> attrs) {
        return (String)attrs.get(CLIENT_REGISTRATION_ID_ATTR_NAME);
    }

    static Authentication getAuthentication(Map<String, Object> attrs) {
        return (Authentication)attrs.get(AUTHENTICATION_ATTR_NAME);
    }

    static HttpServletRequest getRequest(Map<String, Object> attrs) {
        return (HttpServletRequest)attrs.get(HTTP_SERVLET_REQUEST_ATTR_NAME);
    }

    static HttpServletResponse getResponse(Map<String, Object> attrs) {
        return (HttpServletResponse)attrs.get(HTTP_SERVLET_RESPONSE_ATTR_NAME);
    }

    static class RequestContextDataHolder {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final Authentication authentication;

        RequestContextDataHolder(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable Authentication authentication) {
            this.request = request;
            this.response = response;
            this.authentication = authentication;
        }

        @Nullable
        private HttpServletRequest getRequest() {
            return this.request;
        }

        @Nullable
        private HttpServletResponse getResponse() {
            return this.response;
        }

        @Nullable
        private Authentication getAuthentication() {
            return this.authentication;
        }
    }

    static class RequestContextSubscriber<T>
    implements CoreSubscriber<T> {
        static final String REQUEST_CONTEXT_DATA_HOLDER = RequestContextSubscriber.class.getName().concat(".REQUEST_CONTEXT_DATA_HOLDER");
        private final CoreSubscriber<T> delegate;
        private final Context context;

        RequestContextSubscriber(CoreSubscriber<T> delegate, HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
            this.delegate = delegate;
            Context parentContext = this.delegate.currentContext();
            Context context = parentContext.hasKey((Object)REQUEST_CONTEXT_DATA_HOLDER) ? parentContext : parentContext.put((Object)REQUEST_CONTEXT_DATA_HOLDER, (Object)new RequestContextDataHolder(request, response, authentication));
            this.context = context;
        }

        @Nullable
        private static RequestContextDataHolder getRequestContext(Context ctx) {
            return (RequestContextDataHolder)ctx.getOrDefault((Object)REQUEST_CONTEXT_DATA_HOLDER, null);
        }

        public Context currentContext() {
            return this.context;
        }

        public void onSubscribe(Subscription s) {
            this.delegate.onSubscribe(s);
        }

        public void onNext(T t) {
            this.delegate.onNext(t);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }

    private static class PrincipalNameAuthentication
    implements Authentication {
        private final String principalName;

        private PrincipalNameAuthentication(String principalName) {
            Assert.hasText((String)principalName, (String)"principalName cannot be empty");
            this.principalName = principalName;
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            throw this.unsupported();
        }

        public Object getCredentials() {
            throw this.unsupported();
        }

        public Object getDetails() {
            throw this.unsupported();
        }

        public Object getPrincipal() {
            return this.getName();
        }

        public boolean isAuthenticated() {
            throw this.unsupported();
        }

        public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
            throw this.unsupported();
        }

        public String getName() {
            return this.principalName;
        }

        private UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException("Not Supported");
        }
    }
}

