/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class DefaultServerOAuth2AuthorizationRequestResolver
implements ServerOAuth2AuthorizationRequestResolver {
    public static final String DEFAULT_REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    public static final String DEFAULT_AUTHORIZATION_REQUEST_PATTERN = "/oauth2/authorization/{registrationId}";
    private static final char PATH_DELIMITER = '/';
    private final ServerWebExchangeMatcher authorizationRequestMatcher;
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private final StringKeyGenerator stateGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder());
    private final StringKeyGenerator codeVerifierGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);

    public DefaultServerOAuth2AuthorizationRequestResolver(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        this(clientRegistrationRepository, (ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher(DEFAULT_AUTHORIZATION_REQUEST_PATTERN));
    }

    public DefaultServerOAuth2AuthorizationRequestResolver(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerWebExchangeMatcher authorizationRequestMatcher) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizationRequestMatcher, (String)"authorizationRequestMatcher cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizationRequestMatcher = authorizationRequestMatcher;
    }

    @Override
    public Mono<OAuth2AuthorizationRequest> resolve(ServerWebExchange exchange) {
        return this.authorizationRequestMatcher.matches(exchange).filter(matchResult -> matchResult.isMatch()).map(ServerWebExchangeMatcher.MatchResult::getVariables).map(variables -> variables.get(DEFAULT_REGISTRATION_ID_URI_VARIABLE_NAME)).cast(String.class).flatMap(clientRegistrationId -> this.resolve(exchange, (String)clientRegistrationId));
    }

    @Override
    public Mono<OAuth2AuthorizationRequest> resolve(ServerWebExchange exchange, String clientRegistrationId) {
        return this.findByRegistrationId(exchange, clientRegistrationId).map(clientRegistration -> this.authorizationRequest(exchange, (ClientRegistration)clientRegistration));
    }

    private Mono<ClientRegistration> findByRegistrationId(ServerWebExchange exchange, String clientRegistration) {
        return this.clientRegistrationRepository.findByRegistrationId(clientRegistration).switchIfEmpty(Mono.error(() -> new ResponseStatusException(HttpStatus.BAD_REQUEST, "Invalid client registration id")));
    }

    private OAuth2AuthorizationRequest authorizationRequest(ServerWebExchange exchange, ClientRegistration clientRegistration) {
        OAuth2AuthorizationRequest.Builder builder;
        String redirectUriStr = DefaultServerOAuth2AuthorizationRequestResolver.expandRedirectUri(exchange.getRequest(), clientRegistration);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("registration_id", clientRegistration.getRegistrationId());
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.authorizationCode();
            if (ClientAuthenticationMethod.NONE.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
                HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
                this.addPkceParameters(attributes, additionalParameters);
                builder.additionalParameters(additionalParameters);
            }
        } else if (AuthorizationGrantType.IMPLICIT.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.implicit();
        } else {
            throw new IllegalArgumentException("Invalid Authorization Grant Type (" + clientRegistration.getAuthorizationGrantType().getValue() + ") for Client Registration with Id: " + clientRegistration.getRegistrationId());
        }
        return builder.clientId(clientRegistration.getClientId()).authorizationUri(clientRegistration.getProviderDetails().getAuthorizationUri()).redirectUri(redirectUriStr).scopes(clientRegistration.getScopes()).state(this.stateGenerator.generateKey()).attributes(attributes).build();
    }

    private static String expandRedirectUri(ServerHttpRequest request, ClientRegistration clientRegistration) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put(DEFAULT_REGISTRATION_ID_URI_VARIABLE_NAME, clientRegistration.getRegistrationId());
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getURI()).replacePath(request.getPath().contextPath().value()).replaceQuery(null).fragment(null).build();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme == null ? "" : scheme);
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host == null ? "" : host);
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        String path = uriComponents.getPath();
        if (StringUtils.hasLength((String)path) && path.charAt(0) != '/') {
            path = '/' + path;
        }
        uriVariables.put("basePath", path == null ? "" : path);
        uriVariables.put("baseUrl", uriComponents.toUriString());
        String action = "";
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            action = "login";
        }
        uriVariables.put("action", action);
        return UriComponentsBuilder.fromUriString((String)clientRegistration.getRedirectUriTemplate()).buildAndExpand(uriVariables).toUriString();
    }

    private void addPkceParameters(Map<String, Object> attributes, Map<String, Object> additionalParameters) {
        String codeVerifier = this.codeVerifierGenerator.generateKey();
        attributes.put("code_verifier", codeVerifier);
        try {
            String codeChallenge = this.createCodeChallenge(codeVerifier);
            additionalParameters.put("code_challenge", codeChallenge);
            additionalParameters.put("code_challenge_method", "S256");
        }
        catch (NoSuchAlgorithmException e) {
            additionalParameters.put("code_challenge", codeVerifier);
        }
    }

    private String createCodeChallenge(String codeVerifier) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }
}

