/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.net.URI;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.OAuth2AuthorizationResponseUtils;
import org.springframework.security.oauth2.client.web.server.ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.server.WebSessionOAuth2ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class ServerOAuth2AuthorizationCodeAuthenticationTokenConverter
implements ServerAuthenticationConverter {
    static final String AUTHORIZATION_REQUEST_NOT_FOUND_ERROR_CODE = "authorization_request_not_found";
    static final String CLIENT_REGISTRATION_NOT_FOUND_ERROR_CODE = "client_registration_not_found";
    private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository = new WebSessionOAuth2ServerAuthorizationRequestRepository();
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;

    public ServerOAuth2AuthorizationCodeAuthenticationTokenConverter(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public void setAuthorizationRequestRepository(ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
        Assert.notNull(authorizationRequestRepository, (String)"authorizationRequestRepository cannot be null");
        this.authorizationRequestRepository = authorizationRequestRepository;
    }

    public Mono<Authentication> convert(ServerWebExchange serverWebExchange) {
        return this.authorizationRequestRepository.removeAuthorizationRequest(serverWebExchange).switchIfEmpty(this.oauth2AuthorizationException(AUTHORIZATION_REQUEST_NOT_FOUND_ERROR_CODE)).flatMap(authorizationRequest -> this.authenticationRequest(serverWebExchange, (OAuth2AuthorizationRequest)authorizationRequest));
    }

    private <T> Mono<T> oauth2AuthorizationException(String errorCode) {
        return Mono.defer(() -> {
            OAuth2Error oauth2Error = new OAuth2Error(errorCode);
            return Mono.error((Throwable)new OAuth2AuthorizationException(oauth2Error));
        });
    }

    private Mono<OAuth2AuthorizationCodeAuthenticationToken> authenticationRequest(ServerWebExchange exchange, OAuth2AuthorizationRequest authorizationRequest) {
        return Mono.just((Object)authorizationRequest).map(OAuth2AuthorizationRequest::getAttributes).flatMap(attributes -> {
            String id = (String)attributes.get("registration_id");
            if (id == null) {
                return this.oauth2AuthorizationException(CLIENT_REGISTRATION_NOT_FOUND_ERROR_CODE);
            }
            return this.clientRegistrationRepository.findByRegistrationId(id);
        }).switchIfEmpty(this.oauth2AuthorizationException(CLIENT_REGISTRATION_NOT_FOUND_ERROR_CODE)).map(clientRegistration -> {
            OAuth2AuthorizationResponse authorizationResponse = ServerOAuth2AuthorizationCodeAuthenticationTokenConverter.convertResponse(exchange);
            OAuth2AuthorizationCodeAuthenticationToken authenticationRequest = new OAuth2AuthorizationCodeAuthenticationToken((ClientRegistration)clientRegistration, new OAuth2AuthorizationExchange(authorizationRequest, authorizationResponse));
            return authenticationRequest;
        });
    }

    private static OAuth2AuthorizationResponse convertResponse(ServerWebExchange exchange) {
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        String redirectUri = UriComponentsBuilder.fromUri((URI)exchange.getRequest().getURI()).query(null).build().toUriString();
        return OAuth2AuthorizationResponseUtils.convert((MultiValueMap<String, String>)queryParams, redirectUri);
    }
}

