/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.client.AuthorizationCodeOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ClientCredentialsOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.DelegatingOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.PasswordOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.util.Assert;

public final class OAuth2AuthorizedClientProviderBuilder {
    private final Map<Class<?>, Builder> builders = new LinkedHashMap();

    private OAuth2AuthorizedClientProviderBuilder() {
    }

    public static OAuth2AuthorizedClientProviderBuilder builder() {
        return new OAuth2AuthorizedClientProviderBuilder();
    }

    public OAuth2AuthorizedClientProviderBuilder provider(OAuth2AuthorizedClientProvider provider) {
        Assert.notNull((Object)provider, (String)"provider cannot be null");
        this.builders.computeIfAbsent(provider.getClass(), k -> () -> provider);
        return this;
    }

    public OAuth2AuthorizedClientProviderBuilder authorizationCode() {
        this.builders.computeIfAbsent(AuthorizationCodeOAuth2AuthorizedClientProvider.class, k -> new AuthorizationCodeGrantBuilder());
        return this;
    }

    public OAuth2AuthorizedClientProviderBuilder refreshToken() {
        this.builders.computeIfAbsent(RefreshTokenOAuth2AuthorizedClientProvider.class, k -> new RefreshTokenGrantBuilder());
        return this;
    }

    public OAuth2AuthorizedClientProviderBuilder refreshToken(Consumer<RefreshTokenGrantBuilder> builderConsumer) {
        RefreshTokenGrantBuilder builder = (RefreshTokenGrantBuilder)this.builders.computeIfAbsent(RefreshTokenOAuth2AuthorizedClientProvider.class, k -> new RefreshTokenGrantBuilder());
        builderConsumer.accept(builder);
        return this;
    }

    public OAuth2AuthorizedClientProviderBuilder clientCredentials() {
        this.builders.computeIfAbsent(ClientCredentialsOAuth2AuthorizedClientProvider.class, k -> new ClientCredentialsGrantBuilder());
        return this;
    }

    public OAuth2AuthorizedClientProviderBuilder clientCredentials(Consumer<ClientCredentialsGrantBuilder> builderConsumer) {
        ClientCredentialsGrantBuilder builder = (ClientCredentialsGrantBuilder)this.builders.computeIfAbsent(ClientCredentialsOAuth2AuthorizedClientProvider.class, k -> new ClientCredentialsGrantBuilder());
        builderConsumer.accept(builder);
        return this;
    }

    public OAuth2AuthorizedClientProviderBuilder password() {
        this.builders.computeIfAbsent(PasswordOAuth2AuthorizedClientProvider.class, k -> new PasswordGrantBuilder());
        return this;
    }

    public OAuth2AuthorizedClientProviderBuilder password(Consumer<PasswordGrantBuilder> builderConsumer) {
        PasswordGrantBuilder builder = (PasswordGrantBuilder)this.builders.computeIfAbsent(PasswordOAuth2AuthorizedClientProvider.class, k -> new PasswordGrantBuilder());
        builderConsumer.accept(builder);
        return this;
    }

    public OAuth2AuthorizedClientProvider build() {
        ArrayList<OAuth2AuthorizedClientProvider> authorizedClientProviders = new ArrayList<OAuth2AuthorizedClientProvider>();
        for (Builder builder : this.builders.values()) {
            authorizedClientProviders.add(builder.build());
        }
        return new DelegatingOAuth2AuthorizedClientProvider(authorizedClientProviders);
    }

    static interface Builder {
        public OAuth2AuthorizedClientProvider build();
    }

    public class PasswordGrantBuilder
    implements Builder {
        private OAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> accessTokenResponseClient;
        private Duration clockSkew;
        private Clock clock;

        private PasswordGrantBuilder() {
        }

        public PasswordGrantBuilder accessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2PasswordGrantRequest> accessTokenResponseClient) {
            this.accessTokenResponseClient = accessTokenResponseClient;
            return this;
        }

        public PasswordGrantBuilder clockSkew(Duration clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public PasswordGrantBuilder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public OAuth2AuthorizedClientProvider build() {
            PasswordOAuth2AuthorizedClientProvider authorizedClientProvider = new PasswordOAuth2AuthorizedClientProvider();
            if (this.accessTokenResponseClient != null) {
                authorizedClientProvider.setAccessTokenResponseClient(this.accessTokenResponseClient);
            }
            if (this.clockSkew != null) {
                authorizedClientProvider.setClockSkew(this.clockSkew);
            }
            if (this.clock != null) {
                authorizedClientProvider.setClock(this.clock);
            }
            return authorizedClientProvider;
        }
    }

    public class ClientCredentialsGrantBuilder
    implements Builder {
        private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> accessTokenResponseClient;
        private Duration clockSkew;
        private Clock clock;

        private ClientCredentialsGrantBuilder() {
        }

        public ClientCredentialsGrantBuilder accessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> accessTokenResponseClient) {
            this.accessTokenResponseClient = accessTokenResponseClient;
            return this;
        }

        public ClientCredentialsGrantBuilder clockSkew(Duration clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public ClientCredentialsGrantBuilder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public OAuth2AuthorizedClientProvider build() {
            ClientCredentialsOAuth2AuthorizedClientProvider authorizedClientProvider = new ClientCredentialsOAuth2AuthorizedClientProvider();
            if (this.accessTokenResponseClient != null) {
                authorizedClientProvider.setAccessTokenResponseClient(this.accessTokenResponseClient);
            }
            if (this.clockSkew != null) {
                authorizedClientProvider.setClockSkew(this.clockSkew);
            }
            if (this.clock != null) {
                authorizedClientProvider.setClock(this.clock);
            }
            return authorizedClientProvider;
        }
    }

    public class RefreshTokenGrantBuilder
    implements Builder {
        private OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> accessTokenResponseClient;
        private Duration clockSkew;
        private Clock clock;

        private RefreshTokenGrantBuilder() {
        }

        public RefreshTokenGrantBuilder accessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> accessTokenResponseClient) {
            this.accessTokenResponseClient = accessTokenResponseClient;
            return this;
        }

        public RefreshTokenGrantBuilder clockSkew(Duration clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public RefreshTokenGrantBuilder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public OAuth2AuthorizedClientProvider build() {
            RefreshTokenOAuth2AuthorizedClientProvider authorizedClientProvider = new RefreshTokenOAuth2AuthorizedClientProvider();
            if (this.accessTokenResponseClient != null) {
                authorizedClientProvider.setAccessTokenResponseClient(this.accessTokenResponseClient);
            }
            if (this.clockSkew != null) {
                authorizedClientProvider.setClockSkew(this.clockSkew);
            }
            if (this.clock != null) {
                authorizedClientProvider.setClock(this.clock);
            }
            return authorizedClientProvider;
        }
    }

    public class AuthorizationCodeGrantBuilder
    implements Builder {
        private AuthorizationCodeGrantBuilder() {
        }

        @Override
        public OAuth2AuthorizedClientProvider build() {
            return new AuthorizationCodeOAuth2AuthorizedClientProvider();
        }
    }
}

