/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.function.client;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ServerOAuth2AuthorizedClientExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final String OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME = OAuth2AuthorizedClient.class.getName();
    private static final String CLIENT_REGISTRATION_ID_ATTR_NAME = OAuth2AuthorizedClient.class.getName().concat(".CLIENT_REGISTRATION_ID");
    private static final String SERVER_WEB_EXCHANGE_ATTR_NAME = ServerWebExchange.class.getName();
    private static final AnonymousAuthenticationToken ANONYMOUS_USER_TOKEN = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
    private ReactiveOAuth2AuthorizedClientManager authorizedClientManager;
    private boolean defaultAuthorizedClientManager;
    private boolean defaultOAuth2AuthorizedClient;
    private String defaultClientRegistrationId;
    @Deprecated
    private Duration accessTokenExpiresSkew = Duration.ofMinutes(1L);
    @Deprecated
    private ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;

    public ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveOAuth2AuthorizedClientManager authorizedClientManager) {
        Assert.notNull((Object)authorizedClientManager, (String)"authorizedClientManager cannot be null");
        this.authorizedClientManager = authorizedClientManager;
    }

    public ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        this.authorizedClientManager = ServerOAuth2AuthorizedClientExchangeFilterFunction.createDefaultAuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        this.defaultAuthorizedClientManager = true;
    }

    private static ReactiveOAuth2AuthorizedClientManager createDefaultAuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().build();
        DefaultReactiveOAuth2AuthorizedClientManager authorizedClientManager = new DefaultReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        return authorizedClientManager;
    }

    public static Consumer<Map<String, Object>> oauth2AuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        return attributes -> attributes.put(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME, authorizedClient);
    }

    private static OAuth2AuthorizedClient oauth2AuthorizedClient(ClientRequest request) {
        return (OAuth2AuthorizedClient)request.attributes().get(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> serverWebExchange(ServerWebExchange serverWebExchange) {
        return attributes -> attributes.put(SERVER_WEB_EXCHANGE_ATTR_NAME, serverWebExchange);
    }

    private static ServerWebExchange serverWebExchange(ClientRequest request) {
        return (ServerWebExchange)request.attributes().get(SERVER_WEB_EXCHANGE_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> clientRegistrationId(String clientRegistrationId) {
        return attributes -> attributes.put(CLIENT_REGISTRATION_ID_ATTR_NAME, clientRegistrationId);
    }

    private static String clientRegistrationId(ClientRequest request) {
        OAuth2AuthorizedClient authorizedClient = ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(request);
        if (authorizedClient != null) {
            return authorizedClient.getClientRegistration().getRegistrationId();
        }
        return (String)request.attributes().get(CLIENT_REGISTRATION_ID_ATTR_NAME);
    }

    public void setDefaultOAuth2AuthorizedClient(boolean defaultOAuth2AuthorizedClient) {
        this.defaultOAuth2AuthorizedClient = defaultOAuth2AuthorizedClient;
    }

    public void setDefaultClientRegistrationId(String clientRegistrationId) {
        this.defaultClientRegistrationId = clientRegistrationId;
    }

    @Deprecated
    public void setClientCredentialsTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient) {
        Assert.notNull(clientCredentialsTokenResponseClient, (String)"clientCredentialsTokenResponseClient cannot be null");
        Assert.state((boolean)this.defaultAuthorizedClientManager, (String)"The client cannot be set when the constructor used is \"ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveOAuth2AuthorizedClientManager)\". Instead, use the constructor \"ServerOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository, OAuth2AuthorizedClientRepository)\".");
        this.clientCredentialsTokenResponseClient = clientCredentialsTokenResponseClient;
        this.updateDefaultAuthorizedClientManager();
    }

    private void updateDefaultAuthorizedClientManager() {
        ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken(configurer -> configurer.clockSkew(this.accessTokenExpiresSkew)).clientCredentials(this::updateClientCredentialsProvider).password(configurer -> configurer.clockSkew(this.accessTokenExpiresSkew)).build();
        ((DefaultReactiveOAuth2AuthorizedClientManager)this.authorizedClientManager).setAuthorizedClientProvider(authorizedClientProvider);
    }

    private void updateClientCredentialsProvider(ReactiveOAuth2AuthorizedClientProviderBuilder.ClientCredentialsGrantBuilder builder) {
        if (this.clientCredentialsTokenResponseClient != null) {
            builder.accessTokenResponseClient(this.clientCredentialsTokenResponseClient);
        }
        builder.clockSkew(this.accessTokenExpiresSkew);
    }

    @Deprecated
    public void setAccessTokenExpiresSkew(Duration accessTokenExpiresSkew) {
        Assert.notNull((Object)accessTokenExpiresSkew, (String)"accessTokenExpiresSkew cannot be null");
        Assert.state((boolean)this.defaultAuthorizedClientManager, (String)"The accessTokenExpiresSkew cannot be set when the constructor used is \"ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveOAuth2AuthorizedClientManager)\". Instead, use the constructor \"ServerOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository, OAuth2AuthorizedClientRepository)\".");
        this.accessTokenExpiresSkew = accessTokenExpiresSkew;
        this.updateDefaultAuthorizedClientManager();
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return this.authorizedClient(request).map(authorizedClient -> this.bearer(request, (OAuth2AuthorizedClient)authorizedClient)).flatMap(arg_0 -> ((ExchangeFunction)next).exchange(arg_0)).switchIfEmpty(Mono.defer(() -> next.exchange(request)));
    }

    private Mono<OAuth2AuthorizedClient> authorizedClient(ClientRequest request) {
        OAuth2AuthorizedClient authorizedClientFromAttrs = ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(request);
        return Mono.justOrEmpty((Object)authorizedClientFromAttrs).switchIfEmpty(Mono.defer(() -> this.authorizeRequest(request).flatMap(this.authorizedClientManager::authorize))).flatMap(authorizedClient -> this.reauthorizeRequest(request, (OAuth2AuthorizedClient)authorizedClient).flatMap(this.authorizedClientManager::authorize));
    }

    private Mono<OAuth2AuthorizeRequest> authorizeRequest(ClientRequest request) {
        Mono<Authentication> authentication = this.currentAuthentication();
        Mono clientRegistrationId = Mono.justOrEmpty((Object)ServerOAuth2AuthorizedClientExchangeFilterFunction.clientRegistrationId(request)).switchIfEmpty(Mono.justOrEmpty((Object)this.defaultClientRegistrationId)).switchIfEmpty(this.clientRegistrationId(authentication));
        Mono serverWebExchange = Mono.justOrEmpty((Object)ServerOAuth2AuthorizedClientExchangeFilterFunction.serverWebExchange(request)).switchIfEmpty(this.currentServerWebExchange()).map(Optional::of).defaultIfEmpty(Optional.empty());
        return Mono.zip((Mono)clientRegistrationId, authentication, (Mono)serverWebExchange).map(t3 -> {
            OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withClientRegistrationId((String)t3.getT1()).principal((Authentication)t3.getT2());
            if (((Optional)t3.getT3()).isPresent()) {
                builder.attribute(ServerWebExchange.class.getName(), ((Optional)t3.getT3()).get());
            }
            return builder.build();
        });
    }

    private Mono<OAuth2AuthorizeRequest> reauthorizeRequest(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        Mono<Authentication> authentication = this.currentAuthentication();
        Mono serverWebExchange = Mono.justOrEmpty((Object)ServerOAuth2AuthorizedClientExchangeFilterFunction.serverWebExchange(request)).switchIfEmpty(this.currentServerWebExchange()).map(Optional::of).defaultIfEmpty(Optional.empty());
        return Mono.zip(authentication, (Mono)serverWebExchange).map(t2 -> {
            OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withAuthorizedClient(authorizedClient).principal((Authentication)t2.getT1());
            if (((Optional)t2.getT2()).isPresent()) {
                builder.attribute(ServerWebExchange.class.getName(), ((Optional)t2.getT2()).get());
            }
            return builder.build();
        });
    }

    private Mono<Authentication> currentAuthentication() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).defaultIfEmpty((Object)ANONYMOUS_USER_TOKEN);
    }

    private Mono<String> clientRegistrationId(Mono<Authentication> authentication) {
        return authentication.filter(t -> this.defaultOAuth2AuthorizedClient && t instanceof OAuth2AuthenticationToken).cast(OAuth2AuthenticationToken.class).map(OAuth2AuthenticationToken::getAuthorizedClientRegistrationId);
    }

    private Mono<ServerWebExchange> currentServerWebExchange() {
        return Mono.subscriberContext().filter(c -> c.hasKey(ServerWebExchange.class)).map(c -> (ServerWebExchange)c.get(ServerWebExchange.class));
    }

    private ClientRequest bearer(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        return ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(authorizedClient.getAccessToken().getTokenValue())).build();
    }
}

