/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JdbcOAuth2AuthorizedClientService
implements OAuth2AuthorizedClientService {
    private static final String COLUMN_NAMES = "client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at";
    private static final String TABLE_NAME = "oauth2_authorized_client";
    private static final String PK_FILTER = "client_registration_id = ? AND principal_name = ?";
    private static final String LOAD_AUTHORIZED_CLIENT_SQL = "SELECT client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at FROM oauth2_authorized_client WHERE client_registration_id = ? AND principal_name = ?";
    private static final String SAVE_AUTHORIZED_CLIENT_SQL = "INSERT INTO oauth2_authorized_client (client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String REMOVE_AUTHORIZED_CLIENT_SQL = "DELETE FROM oauth2_authorized_client WHERE client_registration_id = ? AND principal_name = ?";
    protected final JdbcOperations jdbcOperations;
    protected RowMapper<OAuth2AuthorizedClient> authorizedClientRowMapper;
    protected Function<OAuth2AuthorizedClientHolder, List<SqlParameterValue>> authorizedClientParametersMapper;

    public JdbcOAuth2AuthorizedClientService(JdbcOperations jdbcOperations, ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)jdbcOperations, (String)"jdbcOperations cannot be null");
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.jdbcOperations = jdbcOperations;
        this.authorizedClientRowMapper = new OAuth2AuthorizedClientRowMapper(clientRegistrationRepository);
        this.authorizedClientParametersMapper = new OAuth2AuthorizedClientParametersMapper();
    }

    @Override
    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)clientRegistrationId), new SqlParameterValue(12, (Object)principalName)};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        List result = this.jdbcOperations.query(LOAD_AUTHORIZED_CLIENT_SQL, (PreparedStatementSetter)pss, this.authorizedClientRowMapper);
        return (T)(!result.isEmpty() ? (OAuth2AuthorizedClient)result.get(0) : null);
    }

    @Override
    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        List<SqlParameterValue> parameters = this.authorizedClientParametersMapper.apply(new OAuth2AuthorizedClientHolder(authorizedClient, principal));
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters.toArray());
        this.jdbcOperations.update(SAVE_AUTHORIZED_CLIENT_SQL, (PreparedStatementSetter)pss);
    }

    @Override
    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)clientRegistrationId), new SqlParameterValue(12, (Object)principalName)};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        this.jdbcOperations.update(REMOVE_AUTHORIZED_CLIENT_SQL, (PreparedStatementSetter)pss);
    }

    public final void setAuthorizedClientRowMapper(RowMapper<OAuth2AuthorizedClient> authorizedClientRowMapper) {
        Assert.notNull(authorizedClientRowMapper, (String)"authorizedClientRowMapper cannot be null");
        this.authorizedClientRowMapper = authorizedClientRowMapper;
    }

    public final void setAuthorizedClientParametersMapper(Function<OAuth2AuthorizedClientHolder, List<SqlParameterValue>> authorizedClientParametersMapper) {
        Assert.notNull(authorizedClientParametersMapper, (String)"authorizedClientParametersMapper cannot be null");
        this.authorizedClientParametersMapper = authorizedClientParametersMapper;
    }

    public static final class OAuth2AuthorizedClientHolder {
        private final OAuth2AuthorizedClient authorizedClient;
        private final Authentication principal;

        public OAuth2AuthorizedClientHolder(OAuth2AuthorizedClient authorizedClient, Authentication principal) {
            Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.authorizedClient = authorizedClient;
            this.principal = principal;
        }

        public OAuth2AuthorizedClient getAuthorizedClient() {
            return this.authorizedClient;
        }

        public Authentication getPrincipal() {
            return this.principal;
        }
    }

    public static class OAuth2AuthorizedClientParametersMapper
    implements Function<OAuth2AuthorizedClientHolder, List<SqlParameterValue>> {
        @Override
        public List<SqlParameterValue> apply(OAuth2AuthorizedClientHolder authorizedClientHolder) {
            OAuth2AuthorizedClient authorizedClient = authorizedClientHolder.getAuthorizedClient();
            Authentication principal = authorizedClientHolder.getPrincipal();
            ClientRegistration clientRegistration = authorizedClient.getClientRegistration();
            OAuth2AccessToken accessToken = authorizedClient.getAccessToken();
            OAuth2RefreshToken refreshToken = authorizedClient.getRefreshToken();
            ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
            parameters.add(new SqlParameterValue(12, (Object)clientRegistration.getRegistrationId()));
            parameters.add(new SqlParameterValue(12, (Object)principal.getName()));
            parameters.add(new SqlParameterValue(12, (Object)accessToken.getTokenType().getValue()));
            parameters.add(new SqlParameterValue(2004, (Object)accessToken.getTokenValue().getBytes(StandardCharsets.UTF_8)));
            parameters.add(new SqlParameterValue(93, (Object)Timestamp.from(accessToken.getIssuedAt())));
            parameters.add(new SqlParameterValue(93, (Object)Timestamp.from(accessToken.getExpiresAt())));
            String accessTokenScopes = null;
            if (!CollectionUtils.isEmpty((Collection)accessToken.getScopes())) {
                accessTokenScopes = StringUtils.collectionToDelimitedString((Collection)accessToken.getScopes(), (String)",");
            }
            parameters.add(new SqlParameterValue(12, (Object)accessTokenScopes));
            byte[] refreshTokenValue = null;
            Timestamp refreshTokenIssuedAt = null;
            if (refreshToken != null) {
                refreshTokenValue = refreshToken.getTokenValue().getBytes(StandardCharsets.UTF_8);
                if (refreshToken.getIssuedAt() != null) {
                    refreshTokenIssuedAt = Timestamp.from(refreshToken.getIssuedAt());
                }
            }
            parameters.add(new SqlParameterValue(2004, (Object)refreshTokenValue));
            parameters.add(new SqlParameterValue(93, (Object)refreshTokenIssuedAt));
            return parameters;
        }
    }

    public static class OAuth2AuthorizedClientRowMapper
    implements RowMapper<OAuth2AuthorizedClient> {
        protected final ClientRegistrationRepository clientRegistrationRepository;

        public OAuth2AuthorizedClientRowMapper(ClientRegistrationRepository clientRegistrationRepository) {
            Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
            this.clientRegistrationRepository = clientRegistrationRepository;
        }

        public OAuth2AuthorizedClient mapRow(ResultSet rs, int rowNum) throws SQLException {
            String clientRegistrationId = rs.getString("client_registration_id");
            ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
            if (clientRegistration == null) {
                throw new DataRetrievalFailureException("The ClientRegistration with id '" + clientRegistrationId + "' exists in the data source, however, it was not found in the ClientRegistrationRepository.");
            }
            OAuth2AccessToken.TokenType tokenType = null;
            if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(rs.getString("access_token_type"))) {
                tokenType = OAuth2AccessToken.TokenType.BEARER;
            }
            String tokenValue = new String(rs.getBytes("access_token_value"), StandardCharsets.UTF_8);
            Instant issuedAt = rs.getTimestamp("access_token_issued_at").toInstant();
            Instant expiresAt = rs.getTimestamp("access_token_expires_at").toInstant();
            Set scopes = Collections.emptySet();
            String accessTokenScopes = rs.getString("access_token_scopes");
            if (accessTokenScopes != null) {
                scopes = StringUtils.commaDelimitedListToSet((String)accessTokenScopes);
            }
            OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType, tokenValue, issuedAt, expiresAt, scopes);
            OAuth2RefreshToken refreshToken = null;
            byte[] refreshTokenValue = rs.getBytes("refresh_token_value");
            if (refreshTokenValue != null) {
                tokenValue = new String(refreshTokenValue, StandardCharsets.UTF_8);
                issuedAt = null;
                Timestamp refreshTokenIssuedAt = rs.getTimestamp("refresh_token_issued_at");
                if (refreshTokenIssuedAt != null) {
                    issuedAt = refreshTokenIssuedAt.toInstant();
                }
                refreshToken = new OAuth2RefreshToken(tokenValue, issuedAt);
            }
            String principalName = rs.getString("principal_name");
            return new OAuth2AuthorizedClient(clientRegistration, principalName, accessToken, refreshToken);
        }
    }
}

