/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.URI;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoderJwkSupport;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public final class JwtDecoders {
    public static JwtDecoder fromOidcIssuerLocation(String oidcIssuerLocation) {
        Map<String, Object> openidConfiguration = JwtDecoders.getOpenidConfiguration(oidcIssuerLocation);
        String metadataIssuer = "(unavailable)";
        if (openidConfiguration.containsKey("issuer")) {
            metadataIssuer = openidConfiguration.get("issuer").toString();
        }
        if (!oidcIssuerLocation.equals(metadataIssuer)) {
            throw new IllegalStateException("The Issuer \"" + metadataIssuer + "\" provided in the OpenID Configuration did not match the requested issuer \"" + oidcIssuerLocation + "\"");
        }
        OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefaultWithIssuer(oidcIssuerLocation);
        NimbusJwtDecoderJwkSupport jwtDecoder = new NimbusJwtDecoderJwkSupport(openidConfiguration.get("jwks_uri").toString());
        jwtDecoder.setJwtValidator(jwtValidator);
        return jwtDecoder;
    }

    private static Map<String, Object> getOpenidConfiguration(String issuer) {
        ParameterizedTypeReference<Map<String, Object>> typeReference = new ParameterizedTypeReference<Map<String, Object>>(){};
        RestTemplate rest = new RestTemplate();
        try {
            URI uri = UriComponentsBuilder.fromUriString((String)(issuer + "/.well-known/openid-configuration")).build().toUri();
            RequestEntity request = RequestEntity.get((URI)uri).build();
            return (Map)rest.exchange(request, (ParameterizedTypeReference)typeReference).getBody();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Unable to resolve the OpenID Configuration with the provided Issuer of \"" + issuer + "\"", e);
        }
    }

    private JwtDecoders() {
    }
}

