/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web.access;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.StringUtils;

public final class BearerTokenAccessDeniedHandler
implements AccessDeniedHandler {
    private static final Collection<String> WELL_KNOWN_SCOPE_ATTRIBUTE_NAMES = Arrays.asList("scope", "scp");
    private String realmName;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.realmName != null) {
            parameters.put("realm", this.realmName);
        }
        if (request.getUserPrincipal() instanceof AbstractOAuth2TokenAuthenticationToken) {
            AbstractOAuth2TokenAuthenticationToken token = (AbstractOAuth2TokenAuthenticationToken)((Object)request.getUserPrincipal());
            String scope = BearerTokenAccessDeniedHandler.getScope(token);
            parameters.put("error", "insufficient_scope");
            parameters.put("error_description", String.format("The token provided has insufficient scope [%s] for this request", scope));
            parameters.put("error_uri", "https://tools.ietf.org/html/rfc6750#section-3.1");
            if (StringUtils.hasText((String)scope)) {
                parameters.put("scope", scope);
            }
        }
        String wwwAuthenticate = BearerTokenAccessDeniedHandler.computeWWWAuthenticateHeaderValue(parameters);
        response.addHeader("WWW-Authenticate", wwwAuthenticate);
        response.setStatus(HttpStatus.FORBIDDEN.value());
    }

    public final void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    private static String getScope(AbstractOAuth2TokenAuthenticationToken token) {
        Map<String, Object> attributes = token.getTokenAttributes();
        for (String attributeName : WELL_KNOWN_SCOPE_ATTRIBUTE_NAMES) {
            Object scopes = attributes.get(attributeName);
            if (scopes instanceof String) {
                return (String)scopes;
            }
            if (!(scopes instanceof Collection)) continue;
            Collection coll = (Collection)scopes;
            return coll.stream().map(String::valueOf).collect(Collectors.joining(" "));
        }
        return "";
    }

    private static String computeWWWAuthenticateHeaderValue(Map<String, String> parameters) {
        String wwwAuthenticate = "Bearer";
        if (!parameters.isEmpty()) {
            wwwAuthenticate = wwwAuthenticate + parameters.entrySet().stream().map(attribute -> (String)attribute.getKey() + "=\"" + (String)attribute.getValue() + "\"").collect(Collectors.joining(", ", " ", ""));
        }
        return wwwAuthenticate;
    }
}

