/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.portlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationDetailsSourceImpl;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.portlet.PortletAuthenticationDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.ModelAndView;

public class PortletProcessingInterceptor
implements HandlerInterceptor,
InitializingBean {
    private static final Log logger = LogFactory.getLog(PortletProcessingInterceptor.class);
    private AuthenticationManager authenticationManager;
    private List userNameAttributes;
    private AuthenticationDetailsSource authenticationDetailsSource = new AuthenticationDetailsSourceImpl();
    private boolean useAuthTypeAsCredentials = false;

    public PortletProcessingInterceptor() {
        ((AuthenticationDetailsSourceImpl)this.authenticationDetailsSource).setClazz(PortletAuthenticationDetails.class);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager must be set");
    }

    public boolean preHandleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public boolean preHandleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void postHandleRender(RenderRequest request, RenderResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterActionCompletion(ActionRequest request, ActionResponse response, Object handler, Exception ex) throws Exception {
    }

    public void afterRenderCompletion(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
    }

    public boolean preHandleResource(ResourceRequest request, ResourceResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void postHandleResource(ResourceRequest request, ResourceResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterResourceCompletion(ResourceRequest request, ResourceResponse response, Object handler, Exception ex) throws Exception {
    }

    public boolean preHandleEvent(EventRequest request, EventResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void afterEventCompletion(EventRequest request, EventResponse response, Object handler, Exception ex) throws Exception {
    }

    private boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws Exception {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking secure context token: " + ctx.getAuthentication()));
        }
        if (ctx.getAuthentication() == null) {
            try {
                PreAuthenticatedAuthenticationToken authRequest = new PreAuthenticatedAuthenticationToken(this.getPrincipalFromRequest(request), this.getCredentialsFromRequest(request));
                authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Beginning authentication request for user '" + authRequest.getName() + "'"));
                }
                this.onPreAuthentication(request, response);
                Authentication authResult = this.authenticationManager.authenticate((Authentication)authRequest);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication success: " + authResult));
                }
                ctx.setAuthentication(authResult);
                this.onSuccessfulAuthentication(request, response, authResult);
            }
            catch (AuthenticationException failed) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Authentication failed - updating ContextHolder to contain null Authentication", (Throwable)failed);
                }
                ctx.setAuthentication(null);
                request.getPortletSession().setAttribute("SPRING_SECURITY_LAST_EXCEPTION", (Object)failed, 1);
                this.onUnsuccessfulAuthentication(request, response, failed);
            }
        }
        return true;
    }

    protected Object getPrincipalFromRequest(PortletRequest request) {
        String userPrincipalName;
        String remoteUser = request.getRemoteUser();
        if (remoteUser != null) {
            return remoteUser;
        }
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null && (userPrincipalName = userPrincipal.getName()) != null) {
            return userPrincipalName;
        }
        if (this.userNameAttributes != null) {
            Map userInfo = null;
            try {
                userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
            }
            catch (Exception e) {
                logger.warn((Object)"unable to retrieve USER_INFO map from portlet request", (Throwable)e);
            }
            if (userInfo != null) {
                Iterator i = this.userNameAttributes.iterator();
                while (i.hasNext()) {
                    String principal = (String)userInfo.get(i.next());
                    if (principal == null) continue;
                    return principal;
                }
            }
        }
        return null;
    }

    protected Object getCredentialsFromRequest(PortletRequest request) {
        if (this.useAuthTypeAsCredentials) {
            return request.getAuthType();
        }
        return "dummy";
    }

    protected void onPreAuthentication(PortletRequest request, PortletResponse response) throws AuthenticationException, IOException {
    }

    protected void onSuccessfulAuthentication(PortletRequest request, PortletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(PortletRequest request, PortletResponse response, AuthenticationException failed) throws IOException {
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setUserNameAttributes(List userNameAttributes) {
        this.userNameAttributes = userNameAttributes;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setUseAuthTypeAsCredentials(boolean useAuthTypeAsCredentials) {
        this.useAuthTypeAsCredentials = useAuthTypeAsCredentials;
    }
}

