/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsa.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.encrypt.BytesEncryptor;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.rsa.crypto.RsaKeyHelper;
import org.springframework.security.rsa.crypto.RsaKeyHolder;
import org.springframework.util.Assert;

public class RsaSecretEncryptor
implements BytesEncryptor,
TextEncryptor,
RsaKeyHolder {
    public static final String ALGORITHM = "RSA";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String SALT = "deadbeef";
    private Charset charset;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private Charset defaultCharset;

    public RsaSecretEncryptor() {
        this(RsaKeyHelper.generateKeyPair());
    }

    public RsaSecretEncryptor(KeyPair keyPair) {
        this(DEFAULT_ENCODING, keyPair.getPublic(), keyPair.getPrivate());
    }

    public RsaSecretEncryptor(String pemData) {
        this(RsaKeyHelper.parseKeyPair(pemData));
    }

    public RsaSecretEncryptor(PublicKey publicKey) {
        this(DEFAULT_ENCODING, publicKey, null);
    }

    public RsaSecretEncryptor(String encoding, PublicKey publicKey, PrivateKey privateKey) {
        this.charset = Charset.forName(encoding);
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.defaultCharset = Charset.forName(DEFAULT_ENCODING);
    }

    @Override
    public String getPublicKey() {
        return RsaKeyHelper.encodePublicKey((RSAPublicKey)this.publicKey, "application");
    }

    public String encrypt(String text) {
        return new String(Base64.encode((byte[])this.encrypt(text.getBytes(this.charset))), this.defaultCharset);
    }

    public String decrypt(String encryptedText) {
        Assert.state((this.privateKey != null ? 1 : 0) != 0, (String)"Private key must be provided for decryption");
        return new String(this.decrypt(Base64.decode((byte[])encryptedText.getBytes(this.defaultCharset))), this.charset);
    }

    public byte[] encrypt(byte[] byteArray) {
        return RsaSecretEncryptor.encrypt(byteArray, this.publicKey);
    }

    public byte[] decrypt(byte[] encryptedByteArray) {
        return RsaSecretEncryptor.decrypt(encryptedByteArray, this.privateKey);
    }

    private static byte[] encrypt(byte[] text, PublicKey key) {
        byte[] random = KeyGenerators.secureRandom((int)16).generateKey();
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, key);
            byte[] secret = cipher.doFinal(random);
            ByteArrayOutputStream result = new ByteArrayOutputStream(text.length + 20);
            RsaSecretEncryptor.writeInt(result, secret.length);
            result.write(secret);
            result.write(Encryptors.standard((CharSequence)new String(Hex.encode((byte[])random)), (CharSequence)SALT).encrypt(text));
            return result.toByteArray();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot encrypt", e);
        }
    }

    private static void writeInt(ByteArrayOutputStream result, int length) throws IOException {
        byte[] data = new byte[]{(byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        result.write(data);
    }

    private static int readInt(ByteArrayInputStream result) throws IOException {
        byte[] b = new byte[2];
        result.read(b);
        return (b[0] & 0xFF) << 8 | b[1] & 0xFF;
    }

    private static byte[] decrypt(byte[] text, PrivateKey key) {
        ByteArrayInputStream input = new ByteArrayInputStream(text);
        ByteArrayOutputStream output = new ByteArrayOutputStream(text.length);
        try {
            int length = RsaSecretEncryptor.readInt(input);
            byte[] random = new byte[length];
            input.read(random);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, key);
            String secret = new String(Hex.encode((byte[])cipher.doFinal(random)));
            byte[] buffer = new byte[text.length - random.length - 2];
            input.read(buffer);
            output.write(Encryptors.standard((CharSequence)secret, (CharSequence)SALT).decrypt(buffer));
            return output.toByteArray();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot decrypt", e);
        }
    }
}

