/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public final class Saml2LogoutResponse {
    private static final Function<Map<String, String>, String> DEFAULT_ENCODER = params -> {
        if (params.isEmpty()) {
            return null;
        }
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
        for (Map.Entry component : params.entrySet()) {
            builder.queryParam((String)component.getKey(), new Object[]{UriUtils.encode((String)((String)component.getValue()), (Charset)StandardCharsets.ISO_8859_1)});
        }
        return builder.build(true).toString().substring(1);
    };
    private final String location;
    private final Saml2MessageBinding binding;
    private final Map<String, String> parameters;
    private final Function<Map<String, String>, String> encoder;

    private Saml2LogoutResponse(String location, Saml2MessageBinding binding, Map<String, String> parameters, Function<Map<String, String>, String> encoder) {
        this.location = location;
        this.binding = binding;
        this.parameters = Collections.unmodifiableMap(new LinkedHashMap<String, String>(parameters));
        this.encoder = encoder;
    }

    public String getResponseLocation() {
        return this.location;
    }

    public Saml2MessageBinding getBinding() {
        return this.binding;
    }

    public String getSamlResponse() {
        return this.parameters.get("SAMLResponse");
    }

    public String getRelayState() {
        return this.parameters.get("RelayState");
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParametersQuery() {
        return this.encoder.apply(this.parameters);
    }

    public static Builder withRelyingPartyRegistration(RelyingPartyRegistration registration) {
        return new Builder(registration);
    }

    public static final class Builder {
        private String location;
        private Saml2MessageBinding binding;
        private Map<String, String> parameters = new LinkedHashMap<String, String>();
        private Function<Map<String, String>, String> encoder = DEFAULT_ENCODER;

        private Builder(RelyingPartyRegistration registration) {
            this.location = registration.getAssertingPartyDetails().getSingleLogoutServiceResponseLocation();
            this.binding = registration.getAssertingPartyDetails().getSingleLogoutServiceBinding();
        }

        public Builder samlResponse(String samlResponse) {
            this.parameters.put("SAMLResponse", samlResponse);
            return this;
        }

        public Builder binding(Saml2MessageBinding binding) {
            this.binding = binding;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder relayState(String relayState) {
            this.parameters.put("RelayState", relayState);
            return this;
        }

        public Builder parameters(Consumer<Map<String, String>> parametersConsumer) {
            parametersConsumer.accept(this.parameters);
            return this;
        }

        public Builder parametersQuery(Function<Map<String, String>, String> encoder) {
            this.encoder = encoder;
            return this;
        }

        public Saml2LogoutResponse build() {
            return new Saml2LogoutResponse(this.location, this.binding, this.parameters, this.encoder);
        }
    }
}

