/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.util.function.Consumer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.BaseOpenSamlLogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4Template;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestResolver;
import org.springframework.util.Assert;

public final class OpenSaml4LogoutRequestResolver
implements Saml2LogoutRequestResolver {
    private final BaseOpenSamlLogoutRequestResolver delegate;

    public OpenSaml4LogoutRequestResolver(RelyingPartyRegistrationRepository registrations) {
        this((HttpServletRequest request, String id) -> {
            if (id == null) {
                return null;
            }
            return registrations.findByRegistrationId(id);
        });
    }

    public OpenSaml4LogoutRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this.delegate = new BaseOpenSamlLogoutRequestResolver(relyingPartyRegistrationResolver, new OpenSaml4Template());
    }

    @Override
    public Saml2LogoutRequest resolve(HttpServletRequest request, Authentication authentication) {
        return this.delegate.resolve(request, authentication);
    }

    public void setParametersConsumer(Consumer<LogoutRequestParameters> parametersConsumer) {
        Assert.notNull(parametersConsumer, (String)"parametersConsumer cannot be null");
        this.delegate.setParametersConsumer((BaseOpenSamlLogoutRequestResolver.LogoutRequestParameters parameters) -> parametersConsumer.accept(new LogoutRequestParameters((BaseOpenSamlLogoutRequestResolver.LogoutRequestParameters)parameters)));
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock must not be null");
        this.delegate.setClock(clock);
    }

    public void setRelayStateResolver(Converter<HttpServletRequest, String> relayStateResolver) {
        Assert.notNull(relayStateResolver, (String)"relayStateResolver cannot be null");
        this.delegate.setRelayStateResolver(relayStateResolver);
    }

    public static final class LogoutRequestParameters {
        private final HttpServletRequest request;
        private final RelyingPartyRegistration registration;
        private final Authentication authentication;
        private final LogoutRequest logoutRequest;

        public LogoutRequestParameters(HttpServletRequest request, RelyingPartyRegistration registration, Authentication authentication, LogoutRequest logoutRequest) {
            this.request = request;
            this.registration = registration;
            this.authentication = authentication;
            this.logoutRequest = logoutRequest;
        }

        LogoutRequestParameters(BaseOpenSamlLogoutRequestResolver.LogoutRequestParameters parameters) {
            this(parameters.getRequest(), parameters.getRelyingPartyRegistration(), parameters.getAuthentication(), parameters.getLogoutRequest());
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public LogoutRequest getLogoutRequest() {
            return this.logoutRequest;
        }
    }
}

