/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.reactive.server;

import java.security.Principal;
import java.util.Collection;
import java.util.function.Function;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SecurityExchangeMutators {
    public static Function<ServerWebExchange, ServerWebExchange> withPrincipal(Principal principal) {
        return m -> m.mutate().principal(Mono.just((Object)principal)).build();
    }

    public static Function<ServerWebExchange, ServerWebExchange> withAuthentication(Authentication authentication) {
        return SecurityExchangeMutators.withPrincipal((Principal)authentication);
    }

    public static Function<ServerWebExchange, ServerWebExchange> withUser(UserDetails userDetails) {
        return SecurityExchangeMutators.withAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)userDetails.getPassword(), userDetails.getAuthorities()));
    }

    public static UserExchangeMutator withUser() {
        return SecurityExchangeMutators.withUser("user");
    }

    public static UserExchangeMutator withUser(String username) {
        return new UserExchangeMutator(username);
    }

    public static class UserExchangeMutator
    implements Function<ServerWebExchange, ServerWebExchange> {
        private final User.UserBuilder userBuilder;

        private UserExchangeMutator(String username) {
            this.userBuilder = User.withUsername((String)username);
            this.password("password");
            this.roles("USER");
        }

        public UserExchangeMutator password(String password) {
            this.userBuilder.password(password);
            return this;
        }

        public UserExchangeMutator roles(String ... roles) {
            this.userBuilder.roles(roles);
            return this;
        }

        public UserExchangeMutator authorities(GrantedAuthority ... authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator authorities(Collection<? extends GrantedAuthority> authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator authorities(String ... authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator accountExpired(boolean accountExpired) {
            this.userBuilder.accountExpired(accountExpired);
            return this;
        }

        public UserExchangeMutator accountLocked(boolean accountLocked) {
            this.userBuilder.accountLocked(accountLocked);
            return this;
        }

        public UserExchangeMutator credentialsExpired(boolean credentialsExpired) {
            this.userBuilder.credentialsExpired(credentialsExpired);
            return this;
        }

        public UserExchangeMutator disabled(boolean disabled) {
            this.userBuilder.disabled(disabled);
            return this;
        }

        @Override
        public ServerWebExchange apply(ServerWebExchange serverWebExchange) {
            return SecurityExchangeMutators.withUser(this.userBuilder.build()).apply(serverWebExchange);
        }
    }
}

