/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.channel;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.SpringSecurityFilter;
import org.springframework.security.web.access.channel.ChannelDecisionManager;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.Assert;

public class ChannelProcessingFilter
extends SpringSecurityFilter
implements InitializingBean {
    private ChannelDecisionManager channelDecisionManager;
    private FilterInvocationSecurityMetadataSource filterInvocationSecurityMetadataSource;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.filterInvocationSecurityMetadataSource, (String)"filterInvocationSecurityMetadataSource must be specified");
        Assert.notNull((Object)this.channelDecisionManager, (String)"channelDecisionManager must be specified");
        Collection attrDefs = this.filterInvocationSecurityMetadataSource.getAllConfigAttributes();
        if (attrDefs == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Could not validate configuration attributes as the FilterInvocationSecurityMetadataSource did not return any attributes");
            }
            return;
        }
        HashSet<ConfigAttribute> unsupportedAttributes = new HashSet<ConfigAttribute>();
        for (ConfigAttribute attr : attrDefs) {
            if (this.channelDecisionManager.supports(attr)) continue;
            unsupportedAttributes.add(attr);
        }
        if (unsupportedAttributes.size() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Validated configuration attributes");
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration attributes: " + unsupportedAttributes);
        }
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, chain);
        List attr = this.filterInvocationSecurityMetadataSource.getAttributes(fi);
        if (attr != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Request: " + fi.toString() + "; ConfigAttributes: " + attr));
            }
            this.channelDecisionManager.decide(fi, attr);
            if (fi.getResponse().isCommitted()) {
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public ChannelDecisionManager getChannelDecisionManager() {
        return this.channelDecisionManager;
    }

    public FilterInvocationSecurityMetadataSource getFilterInvocationSecurityMetadataSource() {
        return this.filterInvocationSecurityMetadataSource;
    }

    public void setChannelDecisionManager(ChannelDecisionManager channelDecisionManager) {
        this.channelDecisionManager = channelDecisionManager;
    }

    public void setFilterInvocationSecurityMetadataSource(FilterInvocationSecurityMetadataSource filterInvocationSecurityMetadataSource) {
        this.filterInvocationSecurityMetadataSource = filterInvocationSecurityMetadataSource;
    }

    public int getOrder() {
        return 0;
    }
}

