/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import java.util.List;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.WebExpressionConfigAttribute;
import org.springframework.security.web.access.expression.WebSecurityExpressionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebExpressionVoter
implements AccessDecisionVoter {
    private WebSecurityExpressionHandler expressionHandler = new DefaultWebSecurityExpressionHandler();

    public int vote(Authentication authentication, Object object, List<ConfigAttribute> attributes) {
        assert (authentication != null);
        assert (object != null);
        assert (attributes != null);
        WebExpressionConfigAttribute weca = this.findConfigAttribute(attributes);
        if (weca == null) {
            return 0;
        }
        FilterInvocation fi = (FilterInvocation)object;
        EvaluationContext ctx = this.expressionHandler.createEvaluationContext(authentication, fi);
        return ExpressionUtils.evaluateAsBoolean((Expression)weca.getAuthorizeExpression(), (EvaluationContext)ctx) ? 1 : -1;
    }

    private WebExpressionConfigAttribute findConfigAttribute(List<ConfigAttribute> attributes) {
        for (ConfigAttribute attribute : attributes) {
            if (!(attribute instanceof WebExpressionConfigAttribute)) continue;
            return (WebExpressionConfigAttribute)attribute;
        }
        return null;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute instanceof WebExpressionConfigAttribute;
    }

    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(FilterInvocation.class);
    }

    public void setExpressionHandler(WebSecurityExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }
}

