/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.StringUtils;

class WebSecurityExpressionRoot
extends SecurityExpressionRoot {
    private FilterInvocation filterInvocation;

    WebSecurityExpressionRoot(Authentication a, FilterInvocation fi) {
        super(a);
        this.filterInvocation = fi;
    }

    public boolean hasIpAddress(String ipAddress) {
        int nMaskBits = 0;
        if (ipAddress.indexOf(47) > 0) {
            String[] addressAndMask = StringUtils.split((String)ipAddress, (String)"/");
            ipAddress = addressAndMask[0];
            nMaskBits = Integer.parseInt(addressAndMask[1]);
        }
        InetAddress requiredAddress = this.parseAddress(ipAddress);
        InetAddress remoteAddress = this.parseAddress(this.filterInvocation.getHttpRequest().getRemoteAddr());
        if (!requiredAddress.getClass().equals(remoteAddress.getClass())) {
            throw new IllegalArgumentException("IP Address in expression must be the same type as version returned by request");
        }
        if (nMaskBits == 0) {
            return remoteAddress.equals(requiredAddress);
        }
        byte[] remAddr = remoteAddress.getAddress();
        byte[] reqAddr = requiredAddress.getAddress();
        int oddBits = nMaskBits % 8;
        int nMaskBytes = nMaskBits / 8 + (oddBits == 0 ? 0 : 1);
        byte[] mask = new byte[nMaskBytes];
        Arrays.fill(mask, 0, oddBits == 0 ? mask.length : mask.length - 1, (byte)-1);
        if (oddBits != 0) {
            int finalByte = (1 << oddBits) - 1;
            mask[mask.length - 1] = (byte)(finalByte <<= 8 - oddBits);
        }
        for (int i = 0; i < mask.length; ++i) {
            if ((remAddr[i] & mask[i]) == (reqAddr[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    private InetAddress parseAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to parse address" + address, e);
        }
    }
}

