/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterChainOrder;
import org.springframework.security.web.SpringSecurityFilter;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;

public class SecurityContextPersistenceFilter
extends SpringSecurityFilter {
    static final String FILTER_APPLIED = "__spring_security_scpf_applied";
    private SecurityContextRepository repo = new HttpSessionSecurityContextRepository();
    private boolean forceEagerSessionCreation = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean debug = this.logger.isDebugEnabled();
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        if (this.forceEagerSessionCreation) {
            HttpSession session = request.getSession();
            if (debug && session.isNew()) {
                this.logger.debug((Object)("Eagerly created session: " + session.getId()));
            }
        }
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder(request, response);
        SecurityContext contextBeforeChainExecution = this.repo.loadContext(holder);
        try {
            SecurityContextHolder.setContext((SecurityContext)contextBeforeChainExecution);
            chain.doFilter((ServletRequest)holder.getRequest(), (ServletResponse)holder.getResponse());
        }
        finally {
            SecurityContext contextAfterChainExecution = SecurityContextHolder.getContext();
            SecurityContextHolder.clearContext();
            this.repo.saveContext(contextAfterChainExecution, holder.getRequest(), holder.getResponse());
            request.removeAttribute(FILTER_APPLIED);
            if (debug) {
                this.logger.debug((Object)"SecurityContextHolder now cleared, as request processing completed");
            }
        }
    }

    public void setSecurityContextRepository(SecurityContextRepository repo) {
        this.repo = repo;
    }

    public void setForceEagerSessionCreation(boolean forceEagerSessionCreation) {
        this.forceEagerSessionCreation = forceEagerSessionCreation;
    }

    public int getOrder() {
        return FilterChainOrder.SECURITY_CONTEXT_FILTER;
    }
}

