/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.concurrent.SessionRegistry;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterChainOrder;
import org.springframework.security.web.SpringSecurityFilter;
import org.springframework.security.web.session.SessionUtils;

public class SessionFixationProtectionFilter
extends SpringSecurityFilter {
    static final String FILTER_APPLIED = "__spring_security_session_fixation_filter_applied";
    private SessionRegistry sessionRegistry;
    private boolean migrateSessionAttributes = true;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getSession(false) == null || request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        HttpSession session = request.getSession();
        SecurityContext sessionSecurityContext = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
        if (sessionSecurityContext == null && this.isAuthenticated()) {
            this.startNewSessionIfRequired(request, response);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && !this.authenticationTrustResolver.isAnonymous(authentication);
    }

    public void setMigrateSessionAttributes(boolean migrateSessionAttributes) {
        this.migrateSessionAttributes = migrateSessionAttributes;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public int getOrder() {
        return FilterChainOrder.SESSION_FIXATION_FILTER;
    }

    protected void startNewSessionIfRequired(HttpServletRequest request, HttpServletResponse response) {
        SessionUtils.startNewSessionIfRequired(request, this.migrateSessionAttributes, this.sessionRegistry);
    }
}

