/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.wrapper;

import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.FilterChainOrder;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.SpringSecurityFilter;
import org.springframework.security.web.wrapper.SavedRequestAwareWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class SecurityContextHolderAwareRequestFilter
extends SpringSecurityFilter {
    private Class<? extends HttpServletRequest> wrapperClass = SavedRequestAwareWrapper.class;
    private Constructor<? extends HttpServletRequest> constructor;
    private PortResolver portResolver = new PortResolverImpl();
    private String rolePrefix;

    public void setPortResolver(PortResolver portResolver) {
        Assert.notNull((Object)portResolver, (String)"PortResolver required");
        this.portResolver = portResolver;
    }

    public void setWrapperClass(Class wrapperClass) {
        Assert.notNull((Object)wrapperClass, (String)"WrapperClass required");
        Assert.isTrue((boolean)HttpServletRequest.class.isAssignableFrom(wrapperClass), (String)"Wrapper must be a HttpServletRequest");
        this.wrapperClass = wrapperClass;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"Role prefix must not be null");
        this.rolePrefix = rolePrefix.trim();
    }

    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.wrapperClass.isAssignableFrom(request.getClass())) {
            try {
                if (this.constructor == null) {
                    this.constructor = this.wrapperClass.getConstructor(HttpServletRequest.class, PortResolver.class, String.class);
                }
                request = this.constructor.newInstance(request, this.portResolver, this.rolePrefix);
            }
            catch (Exception ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public int getOrder() {
        return FilterChainOrder.SERVLET_API_SUPPORT_FILTER;
    }
}

