/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.util.Assert;

public class RequestHeaderPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private String principalRequestHeader = "SM_USER";
    private String credentialsRequestHeader;

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String principal = request.getHeader(this.principalRequestHeader);
        if (principal == null) {
            throw new PreAuthenticatedCredentialsNotFoundException(this.principalRequestHeader + " header not found in request.");
        }
        return principal;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        if (this.credentialsRequestHeader != null) {
            String credentials = request.getHeader(this.credentialsRequestHeader);
            return credentials;
        }
        return "N/A";
    }

    public void setPrincipalRequestHeader(String principalRequestHeader) {
        Assert.hasText((String)principalRequestHeader, (String)"principalRequestHeader must not be empty or null");
        this.principalRequestHeader = principalRequestHeader;
    }

    public void setCredentialsRequestHeader(String credentialsRequestHeader) {
        Assert.hasText((String)credentialsRequestHeader, (String)"credentialsRequestHeader must not be empty or null");
        this.credentialsRequestHeader = credentialsRequestHeader;
    }
}

