/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.session.AuthenticatedSessionStrategy;
import org.springframework.security.web.session.DefaultAuthenticatedSessionStrategy;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class SessionManagementFilter
extends GenericFilterBean {
    static final String FILTER_APPLIED = "__spring_security_session_fixation_filter_applied";
    private final SecurityContextRepository securityContextRepository;
    private AuthenticatedSessionStrategy sessionStrategy = new DefaultAuthenticatedSessionStrategy();
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private String invalidSessionUrl;

    public SessionManagementFilter(SecurityContextRepository securityContextRepository) {
        this.securityContextRepository = securityContextRepository;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        if (!this.securityContextRepository.containsContext(request)) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && !this.authenticationTrustResolver.isAnonymous(authentication)) {
                this.sessionStrategy.onAuthenticationSuccess(authentication, request, response);
            } else if (request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid() && this.invalidSessionUrl != null) {
                response.sendRedirect(this.invalidSessionUrl);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void setAuthenticatedSessionStrategy(AuthenticatedSessionStrategy sessionStrategy) {
        Assert.notNull((Object)sessionStrategy, (String)"authenticatedSessionStratedy must not be null");
        this.sessionStrategy = sessionStrategy;
    }

    public void setInvalidSessionUrl(String invalidSessionUrl) {
        this.invalidSessionUrl = invalidSessionUrl;
    }
}

