/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RedirectUtils {
    private RedirectUtils() {
    }

    public static final void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url, boolean useRelativeContext) throws IOException {
        String finalUrl;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            finalUrl = useRelativeContext ? url : request.getContextPath() + url;
        } else if (useRelativeContext) {
            int len = request.getContextPath().length();
            int index = url.indexOf(request.getContextPath()) + len;
            finalUrl = url.substring(index);
            if (finalUrl.length() > 1 && finalUrl.charAt(0) == '/') {
                finalUrl = finalUrl.substring(1);
            }
        } else {
            finalUrl = url;
        }
        response.sendRedirect(response.encodeRedirectURL(finalUrl));
    }
}

