/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import javax.servlet.http.HttpServletRequest;

public final class UrlUtils {
    public static String buildFullRequestUrl(HttpServletRequest r) {
        return UrlUtils.buildFullRequestUrl(r.getScheme(), r.getServerName(), r.getServerPort(), r.getContextPath(), r.getServletPath(), r.getRequestURI(), r.getPathInfo(), r.getQueryString());
    }

    public static String buildFullRequestUrl(String scheme, String serverName, int serverPort, String contextPath, String servletPath, String requestURI, String pathInfo, String queryString) {
        boolean includePort = true;
        if ("http".equals(scheme.toLowerCase()) && serverPort == 80) {
            includePort = false;
        }
        if ("https".equals(scheme.toLowerCase()) && serverPort == 443) {
            includePort = false;
        }
        return scheme + "://" + serverName + (includePort ? ":" + serverPort : "") + contextPath + UrlUtils.buildRequestUrl(servletPath, requestURI, contextPath, pathInfo, queryString);
    }

    public static String buildRequestUrl(HttpServletRequest r) {
        return UrlUtils.buildRequestUrl(r.getServletPath(), r.getRequestURI(), r.getContextPath(), r.getPathInfo(), r.getQueryString());
    }

    public static String buildRequestUrl(String servletPath, String requestURI, String contextPath, String pathInfo, String queryString) {
        String uri = servletPath;
        if (uri == null) {
            uri = requestURI;
            uri = uri.substring(contextPath.length());
        }
        return uri + (pathInfo == null ? "" : pathInfo) + (queryString == null ? "" : "?" + queryString);
    }

    public static boolean isValidRedirectUrl(String url) {
        return url != null && url.startsWith("/") || url.toLowerCase().startsWith("http");
    }
}

