/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.expression.SecurityExpressionRootPropertyAccessor;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

public class DefaultWebSecurityExpressionHandler
implements WebSecurityExpressionHandler,
ApplicationContextAware {
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    private final SecurityExpressionRootPropertyAccessor sxrpa = new SecurityExpressionRootPropertyAccessor();
    private RoleHierarchy roleHierarchy;
    private ApplicationContext applicationContext;

    public ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public EvaluationContext createEvaluationContext(Authentication authentication, FilterInvocation fi) {
        WebSecurityExpressionRoot root = new WebSecurityExpressionRoot(authentication, fi);
        root.setTrustResolver(this.trustResolver);
        root.setRoleHierarchy(this.roleHierarchy);
        root.setApplicationContext(this.applicationContext);
        StandardEvaluationContext ctx = new StandardEvaluationContext((Object)root);
        ctx.addPropertyAccessor((PropertyAccessor)this.sxrpa);
        return ctx;
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.roleHierarchy = roleHierarchy;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

