/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import java.util.Map;
import java.util.UUID;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.DefaultCsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class WebSessionServerCsrfTokenRepository
implements ServerCsrfTokenRepository {
    private static final String DEFAULT_CSRF_PARAMETER_NAME = "_csrf";
    private static final String DEFAULT_CSRF_HEADER_NAME = "X-CSRF-TOKEN";
    private static final String DEFAULT_CSRF_TOKEN_ATTR_NAME = WebSessionServerCsrfTokenRepository.class.getName().concat(".CSRF_TOKEN");
    private String parameterName = "_csrf";
    private String headerName = "X-CSRF-TOKEN";
    private String sessionAttributeName = DEFAULT_CSRF_TOKEN_ATTR_NAME;

    @Override
    public Mono<CsrfToken> generateToken(ServerWebExchange exchange) {
        return Mono.defer(() -> Mono.just((Object)this.createCsrfToken())).flatMap(token -> this.save(exchange, (CsrfToken)token));
    }

    @Override
    public Mono<Void> saveToken(ServerWebExchange exchange, CsrfToken token) {
        return this.save(exchange, token).then();
    }

    private Mono<CsrfToken> save(ServerWebExchange exchange, CsrfToken token) {
        return exchange.getSession().map(WebSession::getAttributes).flatMap(attrs -> this.save((Map<String, Object>)attrs, token));
    }

    private Mono<CsrfToken> save(Map<String, Object> attributes, CsrfToken token) {
        if (token == null) {
            attributes.remove(this.sessionAttributeName);
        } else {
            attributes.put(this.sessionAttributeName, token);
        }
        return Mono.justOrEmpty((Object)token);
    }

    @Override
    public Mono<CsrfToken> loadToken(ServerWebExchange exchange) {
        return exchange.getSession().filter(s -> s.getAttributes().containsKey(this.sessionAttributeName)).map(s -> (CsrfToken)s.getAttribute(this.sessionAttributeName));
    }

    public void setParameterName(String parameterName) {
        Assert.hasLength((String)parameterName, (String)"parameterName cannot be null or empty");
        this.parameterName = parameterName;
    }

    public void setHeaderName(String headerName) {
        Assert.hasLength((String)headerName, (String)"headerName cannot be null or empty");
        this.headerName = headerName;
    }

    public void setSessionAttributeName(String sessionAttributeName) {
        Assert.hasLength((String)sessionAttributeName, (String)"sessionAttributename cannot be null or empty");
        this.sessionAttributeName = sessionAttributeName;
    }

    private CsrfToken createCsrfToken() {
        return new DefaultCsrfToken(this.headerName, this.parameterName, this.createNewToken());
    }

    private String createNewToken() {
        return UUID.randomUUID().toString();
    }
}

