/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.switchuser;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public final class SwitchUserGrantedAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 520L;
    private final String role;
    private final Authentication source;

    public SwitchUserGrantedAuthority(String role, Authentication source) {
        Assert.notNull((Object)role, (String)"role cannot be null");
        Assert.notNull((Object)source, (String)"source cannot be null");
        this.role = role;
        this.source = source;
    }

    public Authentication getSource() {
        return this.source;
    }

    public String getAuthority() {
        return this.role;
    }

    public int hashCode() {
        return 0x1F ^ this.source.hashCode() ^ this.role.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SwitchUserGrantedAuthority) {
            SwitchUserGrantedAuthority swa = (SwitchUserGrantedAuthority)obj;
            return this.role.equals(swa.role) && this.source.equals(swa.source);
        }
        return false;
    }

    public String toString() {
        return "Switch User Authority [" + this.role + "," + this.source + "]";
    }
}

