/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.server.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.WebFilterChainAuthenticationSuccessHandler;
import org.springframework.security.web.server.context.SecurityContextRepository;
import org.springframework.security.web.server.context.ServerWebExchangeAttributeSecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class DefaultAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private SecurityContextRepository securityContextRepository = new ServerWebExchangeAttributeSecurityContextRepository();
    private AuthenticationSuccessHandler delegate = new WebFilterChainAuthenticationSuccessHandler();

    @Override
    public Mono<Void> success(Authentication authentication, ServerWebExchange exchange, WebFilterChain chain) {
        SecurityContextImpl securityContext = new SecurityContextImpl();
        securityContext.setAuthentication(authentication);
        return this.securityContextRepository.save(exchange, (SecurityContext)securityContext).flatMap(wrappedExchange -> this.delegate.success(authentication, (ServerWebExchange)wrappedExchange, chain));
    }

    public void setDelegate(AuthenticationSuccessHandler delegate) {
        Assert.notNull((Object)delegate, (String)"delegate cannot be null");
        this.delegate = delegate;
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
    }
}

