/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authorization;

import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AuthorizationWebFilter
implements WebFilter {
    private ReactiveAuthorizationManager<? super ServerWebExchange> accessDecisionManager;

    public AuthorizationWebFilter(ReactiveAuthorizationManager<? super ServerWebExchange> accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.accessDecisionManager.verify(exchange.getPrincipal(), (Object)exchange).switchIfEmpty(Mono.defer(() -> chain.filter(exchange)));
    }
}

