/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authorization;

import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.AuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.www.HttpBasicAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.AccessDeniedHandler;
import org.springframework.security.web.server.authorization.HttpStatusAccessDeniedHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ExceptionTranslationWebFilter
implements WebFilter {
    private AuthenticationEntryPoint entryPoint = new HttpBasicAuthenticationEntryPoint();
    private AccessDeniedHandler accessDeniedHandler = new HttpStatusAccessDeniedHandler(HttpStatus.FORBIDDEN);

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return chain.filter(exchange).onErrorResume(AccessDeniedException.class, denied -> exchange.getPrincipal().switchIfEmpty(Mono.defer(() -> this.entryPoint.commence(exchange, (AuthenticationException)new AuthenticationCredentialsNotFoundException("Not Authenticated", (Throwable)denied)))).flatMap(principal -> this.accessDeniedHandler.handle(exchange, (AccessDeniedException)denied)));
    }
}

