/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.context;

import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.server.context.SecurityContextRepository;
import org.springframework.security.web.server.context.SecurityContextRepositoryServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebSessionSecurityContextRepository
implements SecurityContextRepository {
    final String SESSION_ATTR = "USER";

    @Override
    public Mono<ServerWebExchange> save(ServerWebExchange exchange, SecurityContext context) {
        return exchange.getSession().doOnNext(session -> session.getAttributes().put("USER", context)).flatMap(session -> Mono.just((Object)((Object)new SecurityContextRepositoryServerWebExchange(exchange, this))));
    }

    @Override
    public Mono<SecurityContext> load(ServerWebExchange exchange) {
        return exchange.getSession().flatMap(session -> {
            SecurityContext context = (SecurityContext)session.getAttributes().get("USER");
            return context == null ? Mono.empty() : Mono.just((Object)context);
        });
    }
}

