/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.header;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.security.web.server.header.HttpHeadersWriter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CompositeHttpHeadersWriter
implements HttpHeadersWriter {
    private final List<HttpHeadersWriter> writers;

    public CompositeHttpHeadersWriter(HttpHeadersWriter ... writers) {
        this(Arrays.asList(writers));
    }

    public CompositeHttpHeadersWriter(List<HttpHeadersWriter> writers) {
        this.writers = writers;
    }

    @Override
    public Mono<Void> writeHttpHeaders(ServerWebExchange exchange) {
        Stream<Mono> results = this.writers.stream().map(writer -> writer.writeHttpHeaders(exchange));
        return Mono.when((Iterable)results.collect(Collectors.toList()));
    }
}

