/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.util.matcher;

import java.util.ArrayList;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathMatcherServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class ServerWebExchangeMatchers {
    public static ServerWebExchangeMatcher pathMatchers(HttpMethod method, String ... patterns) {
        ArrayList<ServerWebExchangeMatcher> matchers = new ArrayList<ServerWebExchangeMatcher>(patterns.length);
        for (String pattern : patterns) {
            matchers.add(new PathMatcherServerWebExchangeMatcher(pattern, method));
        }
        return new OrServerWebExchangeMatcher(matchers);
    }

    public static ServerWebExchangeMatcher pathMatchers(String ... patterns) {
        return ServerWebExchangeMatchers.pathMatchers(null, patterns);
    }

    public static ServerWebExchangeMatcher matchers(ServerWebExchangeMatcher ... matchers) {
        return new OrServerWebExchangeMatcher(matchers);
    }

    public static ServerWebExchangeMatcher anyExchange() {
        return new ServerWebExchangeMatcher(){

            @Override
            public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
                return ServerWebExchangeMatcher.MatchResult.match();
            }
        };
    }

    private ServerWebExchangeMatchers() {
    }
}

