/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication.logout;

import java.util.Collection;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.LogoutHandler;
import org.springframework.security.web.server.authentication.logout.SecurityContextRepositoryLogoutHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LogoutWebFilter
implements WebFilter {
    private AnonymousAuthenticationToken anonymousAuthenticationToken = new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    private LogoutHandler logoutHandler = new SecurityContextRepositoryLogoutHandler();
    private ServerWebExchangeMatcher requiresLogout = ServerWebExchangeMatchers.pathMatchers("/logout");

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.requiresLogout.matches(exchange).filter(result -> result.isMatch()).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(result -> this.authentication(exchange)).flatMap(authentication -> this.logoutHandler.logout(new WebFilterExchange(exchange, chain), (Authentication)authentication));
    }

    private Mono<Authentication> authentication(ServerWebExchange exchange) {
        return exchange.getPrincipal().cast(Authentication.class).defaultIfEmpty((Object)this.anonymousAuthenticationToken);
    }

    public final void setLogoutHandler(LogoutHandler logoutHandler) {
        Assert.notNull((Object)logoutHandler, (String)"logoutHandler must not be null");
        this.logoutHandler = logoutHandler;
    }

    public final void setRequiresLogout(ServerWebExchangeMatcher serverWebExchangeMatcher) {
        Assert.notNull((Object)serverWebExchangeMatcher, (String)"serverWebExchangeMatcher must not be null");
        this.requiresLogout = serverWebExchangeMatcher;
    }
}

